/*
 * Decompiled with CFR 0.152.
 */
package net.dclausen.microfloat;

import java.util.Random;
import net.dclausen.microfloat.BitUtils;
import net.dclausen.microfloat.MicroFloat;

public class MicroDouble {
    public static final long POSITIVE_INFINITY = 0x7FF0000000000000L;
    public static final long NEGATIVE_INFINITY = -4503599627370496L;
    public static final long NaN = 9221120237041090560L;
    public static final long MAX_VALUE = 0x7FEFFFFFFFFFFFFFL;
    public static final long MIN_VALUE = 1L;
    public static final long E = 4613303445314885481L;
    public static final long PI = 4614256656552045848L;
    public static final long ZERO = 0L;
    public static final long NEGATIVE_ZERO = Long.MIN_VALUE;
    public static final long ONE = 0x3FF0000000000000L;
    public static final long NEGATIVE_ONE = -4616189618054758400L;
    public static final long TWO = 0x4000000000000000L;
    public static final long THREE = 0x4008000000000000L;
    public static final long FOUR = 0x4010000000000000L;
    public static final long FIVE = 0x4014000000000000L;
    public static final long SIX = 4618441417868443648L;
    public static final long EIGHT = 0x4020000000000000L;
    public static final long TEN = 0x4024000000000000L;
    public static final long ONE_HUNDRED = 4636737291354636288L;
    public static final long THREE_HALVES = 4609434218613702656L;
    public static final long ONE_HALF = 4602678819172646912L;
    public static final long ONE_THIRD = 4599676419421066581L;
    public static final long ONE_FOURTH = 4598175219545276416L;
    public static final long ONE_EIGHTH = 4593671619917905920L;
    public static final long LN2 = 4604418534313441775L;
    private static final long ABS_MASK = Long.MAX_VALUE;
    private static final long SIGN_MASK = Long.MIN_VALUE;
    private static final long EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long FRACTION_MASK = 0xFFFFFFFFFFFFFL;
    private static final long IMPLIED_ONE = 0x10000000000000L;
    private static Random random;
    private static final long[] pow10m;
    private static final short[] pow10x;
    private static final long[] pow2m;
    private static final short[] pow2x;
    private static final long ONE_EIGHTY = 4640537203540230144L;
    private static final long TWO_HUNDRED = 4641240890982006784L;
    private static final long EXP_UNDERFLOW = -4573606559926636463L;
    private static final long EXP_OVERFLOW = 4649454530587146735L;
    private static final long LN2_HI = 4604418534311723008L;
    private static final long LN2_LO = 4461442080421002358L;
    private static final long INV_LN2 = 4609176140021203710L;
    private static final long P1 = 4595172819793696062L;
    private static final long P2 = -4654820494858601069L;
    private static final long P3 = 4544508515198557740L;
    private static final long P4 = -4702957295668925455L;
    private static final long P5 = 4496342204012209360L;
    private static final long Q1 = -4638407376216452876L;
    private static final long Q2 = 4564962959435912581L;
    private static final long Q3 = -4677887503499600969L;
    private static final long Q4 = 4526346094260933177L;
    private static final long Q5 = -4716678695450197203L;
    private static final long[] BP;
    private static final long[] DP_HI;
    private static final long[] DP_LO;
    private static final long L1 = 4603579539098120963L;
    private static final long L2 = 4601392076422097919L;
    private static final long L3 = 4599676419357746765L;
    private static final long L4 = 4598584653024936193L;
    private static final long L5 = 4597478449480325989L;
    private static final long L6 = 4596625081194860271L;
    private static final long LN2_HI_B = 4604418534330597376L;
    private static final long LN2_LO_B = -4746692435354555335L;
    private static final long OVT = 4365981760143196926L;
    private static final long CP = 4606838314010018813L;
    private static final long CP_HI = 4606838314073325568L;
    private static final long CP_LO = -4738297118486494731L;
    private static final long INV_LN2_HI = 4609176139934466048L;
    private static final long INV_LN2_LO = 4491406094830001988L;
    private static final long IVLN10 = 4601495173785380110L;
    private static final long LOG10_2HI = 4599094494223097856L;
    private static final long LOG10_2LO = 4420844829172378422L;
    private static final long LG1 = 4604180019048437139L;
    private static final long LG2 = 4600877379321592324L;
    private static final long LG3 = 4598818590951641945L;
    private static final long LG4 = 4597174411056806063L;
    private static final long LG5 = 4595719342595441630L;
    private static final long LG6 = 4594685411790997151L;
    private static final long LG7 = 4594499633228436036L;
    private static final long LP1 = 4604180019048437139L;
    private static final long LP2 = 4600877379321592324L;
    private static final long LP3 = 4598818590951641945L;
    private static final long LP4 = 4597174411056806063L;
    private static final long LP5 = 4595719342595441630L;
    private static final long LP6 = 4594685411790997151L;
    private static final long LP7 = 4594499633228436036L;
    private static final long PIO4 = 4605249457297304856L;
    private static final long PIO4_LO = 4359948597267291143L;
    private static final long T0 = 4599676419421066595L;
    private static final long T1 = 4593971859893059194L;
    private static final long T2 = 4587938466107703806L;
    private static final long T3 = 4581960672245896759L;
    private static final long T4 = 4576262931677611155L;
    private static final long T5 = 4570429193025094440L;
    private static final long T6 = 4564358403679355669L;
    private static final long T7 = 4558562946408670465L;
    private static final long T8 = 4553182066015801448L;
    private static final long T9 = 4545397049192321702L;
    private static final long T10 = 4544897349388904425L;
    private static final long T11 = -4687273268743220365L;
    private static final long T12 = 4538267711989316308L;
    private static long S1;
    private static long S2;
    private static long S3;
    private static long S4;
    private static long S5;
    private static long S6;
    private static final long C1 = 4586165620538955084L;
    private static final long C2 = -4659324094485802633L;
    private static final long C3 = 4537941361668330896L;
    private static final long C4 = -4714566979978243411L;
    private static final long C5 = 4477121870137962948L;
    private static final long C6 = -4780295122622859052L;
    private static final long[] PIO2;
    private static final int[] TWO_OVER_PI;
    private static final int[] NPIO2_HW;
    private static final long TWO24 = 4715268809856909312L;
    private static final long INV_PIO2 = 4603909380684499075L;
    private static final long PIO2_1 = 4609753056924401664L;
    private static final long PIO2_1T = 4454258360616903473L;
    private static final long PIO2_2 = 4454258360616747008L;
    private static final long PIO2_2T = 4297306550709743731L;
    private static final long PIO2_3 = 4297306550709518336L;
    private static final long PIO2_3T = 4142048980368378305L;
    private static final long PIO2_HI = 4609753056924675352L;
    private static final long PIO2_LO = 4364452196894661639L;
    private static final long PIO4_HI = 4605249457297304856L;
    private static final long PS0 = 4595172819793696085L;
    private static final long PS1 = -4623835544539140227L;
    private static final long PS2 = 4596417465768494165L;
    private static final long PS3 = -4637438604930937029L;
    private static final long PS4 = 4560439845004096136L;
    private static final long PS5 = 4540259411154564873L;
    private static final long QS1 = -4610777653840302773L;
    private static final long QS2 = 4611733184086379208L;
    private static final long QS3 = -4618997306433404583L;
    private static final long QS4 = 4590215604441354882L;
    private static final long[] atanhi;
    private static final long[] atanlo;
    private static final long AT0 = 4599676419421066509L;
    private static final long AT1 = -4626998257160492092L;
    private static final long AT2 = 4594314991288484863L;
    private static final long AT3 = -4630701217362536847L;
    private static final long AT4 = 4591215095208222830L;
    private static final long AT5 = -4633165035261879699L;
    private static final long AT6 = 4589464229703073105L;
    private static final long AT7 = -4634804155249132134L;
    private static final long AT8 = 4587333258118041067L;
    private static final long AT9 = -4637946461342241745L;
    private static final long AT10 = 4580351289466214929L;
    private static final long A0 = 4590228395698008264L;
    private static final long A1 = 4599480669564178349L;
    private static final long A2 = 4589517665429971623L;
    private static final long A3 = 4581589235564434555L;
    private static final long A4 = 4575164982564483048L;
    private static final long A5 = 4568811493649781355L;
    private static final long A6 = 4563143216008740701L;
    private static final long A7 = 4557843786729364480L;
    private static final long A8 = 4552280422768239949L;
    private static final long A9 = 4547598271341525767L;
    private static final long A10 = 4538063219164248658L;
    private static final long A11 = 4541745596584974391L;
    private static final long TC = 4609261425156079167L;
    private static final long TF = -4629953606387004862L;
    private static final long TT = -4877178723284379873L;
    private static final long TB0 = 4602387636645935266L;
    private static final long TB1 = -4628886608449977079L;
    private static final long TB2 = 4589321138371641755L;
    private static final long TB3 = -4638485889055082733L;
    private static final long TB4 = 4580836915846773228L;
    private static final long TB5 = -4646272669672412054L;
    private static final long TB6 = 4573683464413438788L;
    private static final long TB7 = -4652729689257208617L;
    private static final long TB8 = 4567356815629994261L;
    private static final long TB9 = -4659256875421984015L;
    private static final long TB10 = 4561265769268226281L;
    private static final long TB11 = -4665265148704595732L;
    private static final long TB12 = 4554458007677615095L;
    private static final long TB13 = -4668967117108573128L;
    private static final long TB14 = 4554825044790006772L;
    private static final long U0 = -4633143641156767544L;
    private static final long U1 = 4603875219004743167L;
    private static final long U2 = 4609231207607680367L;
    private static final long U3 = 4606981716134495312L;
    private static final long U4 = 4597417307973683492L;
    private static final long U5 = 4578867296057666313L;
    private static final long V1 = 4612712789461262748L;
    private static final long V2 = 4611975351653570805L;
    private static final long V3 = 4605104324179153071L;
    private static final long V4 = 4592174453748890760L;
    private static final long V5 = 4569564532599476065L;
    private static final long SB0 = -4633143641156767544L;
    private static final long SB1 = 4596913578117826680L;
    private static final long SB2 = 4599540328982355801L;
    private static final long SB3 = 4594440851763360503L;
    private static final long SB4 = 4583336332999498081L;
    private static final long SB5 = 4566129637262422585L;
    private static final long SB6 = 4539839448431978821L;
    private static final long R1 = 4608947853879192436L;
    private static final long R2 = 4604677836871294172L;
    private static final long R3 = 4595362590636105511L;
    private static final long R4 = 4581031541704938613L;
    private static final long R5 = 4560314476338981211L;
    private static final long R6 = 4530263847980990784L;
    private static final long W0 = 4601218545606032745L;
    private static final long W1 = 4590669220166325563L;
    private static final long W2 = -4654820494859555236L;
    private static final long W3 = 4560459357641193654L;
    private static final long W4 = -4664743177309132991L;
    private static final long W5 = 4560853097493747153L;
    private static final long W6 = -4658207879917059100L;
    private static final long TWO52 = 0x4330000000000000L;
    private final long value;

    static boolean unpackSign(long d) {
        return d < 0L;
    }

    static int unpackExponent(long d) {
        return ((int)(d >> 52) & 0x7FF) - 1075;
    }

    static long unpackMantissa(long d) {
        if ((d & 0x7FF0000000000000L) == 0L) {
            return (d & 0xFFFFFFFFFFFFFL) << 1;
        }
        return d & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
    }

    static long pack(boolean negative, int exponent, long mantissa) {
        if (mantissa != 0L) {
            int shift = BitUtils.countLeadingZeros(mantissa);
            mantissa <<= shift;
            if ((exponent -= shift) < -1085) {
                mantissa = BitUtils.roundingRightShift(mantissa, -1074 - exponent);
            } else {
                if ((mantissa = BitUtils.roundingRightShift(mantissa, 11)) == 0x20000000000000L) {
                    mantissa = 0x10000000000000L;
                    ++exponent;
                }
                if (exponent > 960) {
                    mantissa = 0x7FF0000000000000L;
                } else {
                    mantissa ^= 0x10000000000000L;
                    mantissa |= (long)(exponent + 1086) << 52;
                }
            }
        }
        if (negative) {
            mantissa |= Long.MIN_VALUE;
        }
        return mantissa;
    }

    public static boolean isNaN(long d) {
        return (d & Long.MAX_VALUE) > 0x7FF0000000000000L;
    }

    public static boolean isInfinite(long d) {
        return (d & Long.MAX_VALUE) == 0x7FF0000000000000L;
    }

    public static boolean isZero(long d) {
        return (d & Long.MAX_VALUE) == 0L;
    }

    public static long abs(long d) {
        return d & Long.MAX_VALUE;
    }

    public static long negate(long d) {
        if (MicroDouble.isNaN(d)) {
            return 9221120237041090560L;
        }
        return d ^ Long.MIN_VALUE;
    }

    public static boolean eq(long d1, long d2) {
        return d1 == d2 && !MicroDouble.isNaN(d1) || MicroDouble.isZero(d1) && MicroDouble.isZero(d2);
    }

    public static boolean ne(long d1, long d2) {
        return !MicroDouble.eq(d1, d2);
    }

    public static boolean lt(long d1, long d2) {
        if (MicroDouble.isNaN(d1) || MicroDouble.isNaN(d2)) {
            return false;
        }
        if (d2 == 0L) {
            d2 = Long.MIN_VALUE;
        }
        return MicroDouble.cmp(d1, d2) < 0;
    }

    public static boolean le(long d1, long d2) {
        if (MicroDouble.isNaN(d1) || MicroDouble.isNaN(d2)) {
            return false;
        }
        if (d2 == Long.MIN_VALUE) {
            d2 = 0L;
        }
        return MicroDouble.cmp(d1, d2) <= 0;
    }

    public static boolean gt(long d1, long d2) {
        if (MicroDouble.isNaN(d1) || MicroDouble.isNaN(d2)) {
            return false;
        }
        if (d1 == 0L) {
            d1 = Long.MIN_VALUE;
        }
        return MicroDouble.cmp(d1, d2) > 0;
    }

    public static boolean ge(long d1, long d2) {
        if (MicroDouble.isNaN(d1) || MicroDouble.isNaN(d2)) {
            return false;
        }
        if (d1 == Long.MIN_VALUE) {
            d1 = 0L;
        }
        return MicroDouble.cmp(d1, d2) >= 0;
    }

    public static int compare(long d1, long d2) {
        boolean n1 = MicroDouble.isNaN(d1);
        boolean n2 = MicroDouble.isNaN(d2);
        if (n1 || n2) {
            if (n1 && n2) {
                return 0;
            }
            return n1 ? 1 : -1;
        }
        return MicroDouble.cmp(d1, d2);
    }

    public static long max(long d1, long d2) {
        if (MicroDouble.isNaN(d1) || MicroDouble.isNaN(d2)) {
            return 9221120237041090560L;
        }
        return MicroDouble.cmp(d1, d2) >= 0 ? d1 : d2;
    }

    public static long min(long d1, long d2) {
        if (MicroDouble.isNaN(d1) || MicroDouble.isNaN(d2)) {
            return 9221120237041090560L;
        }
        return MicroDouble.cmp(d1, d2) < 0 ? d1 : d2;
    }

    private static int cmp(long d1, long d2) {
        if (d1 == d2) {
            return 0;
        }
        if (d1 < 0L) {
            if (d2 < 0L) {
                return d1 < d2 ? 1 : -1;
            }
            return -1;
        }
        if (d2 < 0L) {
            return 1;
        }
        return d1 < d2 ? -1 : 1;
    }

    public static long intToDouble(int x) {
        return MicroDouble.longToDouble(x);
    }

    public static long longToDouble(long x) {
        if (x < 0L) {
            return MicroDouble.pack(true, 0, -x);
        }
        return MicroDouble.pack(false, 0, x);
    }

    public static long floatToDouble(int f) {
        if (MicroFloat.isNaN(f)) {
            return 9221120237041090560L;
        }
        boolean n = MicroFloat.unpackSign(f);
        if (MicroFloat.isZero(f)) {
            return n ? Long.MIN_VALUE : 0L;
        }
        if (MicroFloat.isInfinite(f)) {
            return n ? -4503599627370496L : 0x7FF0000000000000L;
        }
        int x = MicroFloat.unpackExponent(f);
        long m = MicroFloat.unpackMantissa(f);
        return MicroDouble.pack(n, x, m);
    }

    public static byte byteValue(long d) {
        return (byte)MicroDouble.intValue(d);
    }

    public static short shortValue(long d) {
        return (short)MicroDouble.intValue(d);
    }

    public static int intValue(long d) {
        long x = MicroDouble.longValue(d);
        if (x >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (x <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)x;
    }

    public static long longValue(long d) {
        if (MicroDouble.isNaN(d)) {
            return 0L;
        }
        boolean n = MicroDouble.unpackSign(d);
        int x = MicroDouble.unpackExponent(d);
        long m = MicroDouble.unpackMantissa(d);
        if (x > 0) {
            if (x >= 63 || m >> 63 - x != 0L) {
                return n ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            m <<= x;
        } else {
            if (x <= -53) {
                return 0L;
            }
            m >>>= -x;
        }
        return n ? -m : m;
    }

    public static int floatValue(long d) {
        return MicroFloat.doubleToFloat(d);
    }

    private static synchronized Random getRandom() {
        if (random == null) {
            random = new Random();
        }
        return random;
    }

    public static long random() {
        return MicroDouble.pack(false, -64, MicroDouble.getRandom().nextLong() << 11);
    }

    public static long add(long d1, long d2) {
        long d;
        if (MicroDouble.isNaN(d1) || MicroDouble.isNaN(d2)) {
            return 9221120237041090560L;
        }
        boolean n1 = MicroDouble.unpackSign(d1);
        boolean n2 = MicroDouble.unpackSign(d2);
        boolean i1 = MicroDouble.isInfinite(d1);
        boolean i2 = MicroDouble.isInfinite(d2);
        if (i1 || i2) {
            if (i1 && i2) {
                if (n1 != n2) {
                    return 9221120237041090560L;
                }
                return d1;
            }
            if (i1) {
                return d1;
            }
            return d2;
        }
        boolean z1 = MicroDouble.isZero(d1);
        boolean z2 = MicroDouble.isZero(d2);
        if (z1 || z2) {
            if (z1 && z2) {
                if (n1 != n2) {
                    return 0L;
                }
                return d1;
            }
            if (z1) {
                return d2;
            }
            return d1;
        }
        long m1 = MicroDouble.unpackMantissa(d1) << 3;
        int x1 = MicroDouble.unpackExponent(d1) - 3;
        long m2 = MicroDouble.unpackMantissa(d2) << 3;
        int x2 = MicroDouble.unpackExponent(d2) - 3;
        int dx = x1 - x2;
        if (dx > 0) {
            m2 = BitUtils.stickyRightShift(m2, dx);
            x2 = x1;
        } else if (dx < 0) {
            m1 = BitUtils.stickyRightShift(m1, -dx);
            x1 = x2;
        }
        if (n1 ^ n2) {
            if (m1 > m2) {
                m2 = -m2;
            } else {
                m1 = -m1;
                n1 = n2;
            }
        }
        if ((d = MicroDouble.pack(n1, x1, m1 += m2)) == Long.MIN_VALUE) {
            return 0L;
        }
        return d;
    }

    public static long sub(long d1, long d2) {
        return MicroDouble.add(d1, MicroDouble.negate(d2));
    }

    public static long mul(long d1, long d2) {
        if (MicroDouble.isNaN(d1) || MicroDouble.isNaN(d2)) {
            return 9221120237041090560L;
        }
        boolean negative = MicroDouble.unpackSign(d1) ^ MicroDouble.unpackSign(d2);
        if (MicroDouble.isInfinite(d1) || MicroDouble.isInfinite(d2)) {
            if (MicroDouble.isZero(d1) || MicroDouble.isZero(d2)) {
                return 9221120237041090560L;
            }
            return negative ? -4503599627370496L : 0x7FF0000000000000L;
        }
        long m1 = MicroDouble.unpackMantissa(d1);
        int x1 = MicroDouble.unpackExponent(d1);
        long m2 = MicroDouble.unpackMantissa(d2);
        int x2 = MicroDouble.unpackExponent(d2);
        x1 += x2;
        long m11 = m1 & 0xFFFFFFFL;
        long m12 = m1 >> 28;
        long m21 = m2 & 0xFFFFFFFL;
        long m22 = m2 >> 28;
        long t1 = m11 * m21;
        long t2 = m11 * m22 + m12 * m21;
        long t3 = m12 * m22;
        t3 += t2 >>> 28;
        t1 <<= 8;
        if ((t3 += (t1 += (t2 & 0xFFFFFFFL) << 28) >>> 56) == 0L) {
            return MicroDouble.pack(negative, x1, t1);
        }
        int s = BitUtils.countLeadingZeros(t3);
        x1 += 56 - s;
        t3 <<= s;
        t3 |= t1 >>> 64 - s;
        if (t1 << s != 0L) {
            t3 |= 1L;
        }
        return MicroDouble.pack(negative, x1, t3);
    }

    public static long div(long d1, long d2) {
        if (MicroDouble.isNaN(d1) || MicroDouble.isNaN(d2)) {
            return 9221120237041090560L;
        }
        boolean negative = MicroDouble.unpackSign(d1) ^ MicroDouble.unpackSign(d2);
        boolean n1 = MicroDouble.isInfinite(d1);
        boolean n2 = MicroDouble.isInfinite(d2);
        if (n1 || n2) {
            if (n1 && n2) {
                return 9221120237041090560L;
            }
            if (n1) {
                return negative ? -4503599627370496L : 0x7FF0000000000000L;
            }
            return negative ? Long.MIN_VALUE : 0L;
        }
        n1 = MicroDouble.isZero(d1);
        n2 = MicroDouble.isZero(d2);
        if (n1 || n2) {
            if (n1 && n2) {
                return 9221120237041090560L;
            }
            if (n1) {
                return negative ? Long.MIN_VALUE : 0L;
            }
            return negative ? -4503599627370496L : 0x7FF0000000000000L;
        }
        long m1 = MicroDouble.unpackMantissa(d1);
        int x1 = MicroDouble.unpackExponent(d1);
        long m2 = MicroDouble.unpackMantissa(d2);
        int x2 = MicroDouble.unpackExponent(d2);
        long m = 0L;
        x1 -= x2;
        while (true) {
            int s;
            if ((s = Math.min(BitUtils.countLeadingZeros(m1) - 1, BitUtils.countLeadingZeros(m))) <= 8) {
                if (m1 == 0L) break;
                m |= 1L;
                break;
            }
            m <<= s;
            x1 -= s;
            m |= (m1 <<= s) / m2;
            m1 %= m2;
        }
        return MicroDouble.pack(negative, x1, m);
    }

    public static long mod(long d1, long d2) {
        int x2;
        if (MicroDouble.isNaN(d1) || MicroDouble.isNaN(d2) || MicroDouble.isInfinite(d1) || MicroDouble.isZero(d2)) {
            return 9221120237041090560L;
        }
        if (MicroDouble.isZero(d1) || MicroDouble.isInfinite(d2)) {
            return d1;
        }
        int x1 = MicroDouble.unpackExponent(d1);
        if (x1 < (x2 = MicroDouble.unpackExponent(d2))) {
            return d1;
        }
        boolean n = MicroDouble.unpackSign(d1);
        long m1 = MicroDouble.unpackMantissa(d1);
        long m2 = MicroDouble.unpackMantissa(d2);
        if (x1 == x2) {
            m1 %= m2;
        } else {
            while (x1 != x2) {
                int s = Math.min(BitUtils.countLeadingZeros(m1) - 1, x1 - x2);
                x1 -= s;
                m1 = (m1 << s) % m2;
            }
        }
        return MicroDouble.pack(n, x1, m1);
    }

    public static long truncate(long d) {
        return MicroDouble.round(d, false, MicroDouble.unpackSign(d));
    }

    public static long rint(long d) {
        return MicroDouble.round(d, true, false);
    }

    public static long floor(long d) {
        return MicroDouble.round(d, false, false);
    }

    public static long ceil(long d) {
        return MicroDouble.round(d, false, true);
    }

    public static long round(long d) {
        return MicroDouble.longValue(MicroDouble.floor(MicroDouble.add(d, 4602678819172646912L)));
    }

    private static long round(long d, boolean round, boolean ceil) {
        if (MicroDouble.isNaN(d)) {
            return 9221120237041090560L;
        }
        if (MicroDouble.isZero(d) || MicroDouble.isInfinite(d)) {
            return d;
        }
        int x = MicroDouble.unpackExponent(d);
        if (x >= 0) {
            return d;
        }
        boolean n = MicroDouble.unpackSign(d);
        long m = MicroDouble.unpackMantissa(d);
        if (round) {
            m = BitUtils.roundingRightShift(m, -x);
        } else {
            long r;
            if (x <= -64) {
                r = m;
                m = 0L;
            } else {
                r = m << 64 + x;
                m >>>= -x;
            }
            if (n ^ ceil && r != 0L) {
                ++m;
            }
        }
        return MicroDouble.pack(n, 0, m);
    }

    private static long decToDouble(boolean negative, int base10x, long base10m) {
        if (base10m == 0L) {
            return negative ? Long.MIN_VALUE : 0L;
        }
        while (base10m > 0L && base10m <= 0x1999999999999999L) {
            base10m = (base10m << 3) + (base10m << 1);
            --base10x;
        }
        if ((base10x /= 3) < 0) {
            return negative ? Long.MIN_VALUE : 0L;
        }
        if (base10x > 218) {
            return negative ? -4503599627370496L : 0x7FF0000000000000L;
        }
        int base2x = pow10x[base10x];
        int s = BitUtils.countLeadingZeros(base10m);
        base2x -= s;
        long base2m = MicroDouble.dpMul(base10m <<= s, pow10m[base10x]);
        for (int mod = (base10x += 345) % 3; mod > 0; --mod) {
            if (base2m < 0L) {
                base2m >>>= 1;
                ++base2x;
            }
            base2m += base2m >>> 2;
            base2x += 3;
        }
        return MicroDouble.pack(negative, base2x, base2m);
    }

    private static final long dpMul(long x1, long x2) {
        long v1 = (x1 >>> 32) * (x2 >>> 32);
        long v2 = (x1 & 0xFFFFFFFFL) * (x2 >>> 32);
        long v3 = (x1 >>> 32) * (x2 & 0xFFFFFFFFL);
        v1 += v2 >>> 32;
        v1 += v3 >>> 32;
        if (v2 + v3 << 32 < 0L) {
            ++v1;
        }
        return v1;
    }

    public static long parseDouble(String s) {
        int len = (s = s.trim().toUpperCase()).length();
        if (len == 0) {
            throw new NumberFormatException(s);
        }
        if ("NAN".equals(s)) {
            return 9221120237041090560L;
        }
        int idx = 0;
        boolean negative = false;
        char c = s.charAt(0);
        boolean bl = negative = c == '-';
        if (negative || c == '+') {
            idx = 1;
        }
        if (idx < len && ((c = s.charAt(idx)) == 'I' || c == 'i') && "INFINITY".equals(s.substring(idx))) {
            return negative ? -4503599627370496L : 0x7FF0000000000000L;
        }
        long mantissa = 0L;
        int exponent = 0;
        int fractionChars = 0;
        boolean sticky = false;
        boolean readingFraction = false;
        while (idx < len) {
            c = s.charAt(idx);
            if (c == '.') {
                if (readingFraction) {
                    throw new NumberFormatException(s);
                }
                readingFraction = true;
            } else {
                if (c < '0' || c > '9') break;
                ++fractionChars;
                if (mantissa <= 0x1999999999999998L) {
                    mantissa = (mantissa << 3) + (mantissa << 1) + (long)(c - 48);
                    if (readingFraction) {
                        --exponent;
                    }
                } else {
                    if (!readingFraction) {
                        ++exponent;
                    }
                    sticky |= c != '0';
                }
            }
            ++idx;
        }
        if (fractionChars == 0) {
            throw new NumberFormatException(s);
        }
        if (idx + 1 < len && (s.charAt(idx) == 'E' || s.charAt(idx) == 'e')) {
            try {
                exponent += Integer.parseInt(s.substring(idx + 1));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(s);
            }
            idx = len;
        } else if (idx != len) {
            throw new NumberFormatException(s);
        }
        return MicroDouble.decToDouble(negative, exponent, mantissa);
    }

    public static String toString(long d) {
        return MicroDouble.toString(d, 100);
    }

    public static String toString(long d, int maxStringLength) {
        if (MicroDouble.isNaN(d)) {
            return "NaN";
        }
        boolean n = MicroDouble.unpackSign(d);
        if (MicroDouble.isZero(d)) {
            return n ? "-0.0" : "0.0";
        }
        if (MicroDouble.isInfinite(d)) {
            return n ? "-Infinity" : "Infinity";
        }
        if (maxStringLength < 9) {
            maxStringLength = 9;
        }
        int base2x = MicroDouble.unpackExponent(d);
        long base2m = MicroDouble.unpackMantissa(d);
        int idx = base2x + 1075;
        int dx = idx % 11;
        base2m <<= dx;
        int base10x = pow2x[idx /= 11];
        while (base2m <= 0xCCCCCCCCCCCCCCCL) {
            base2m = (base2m << 3) + (base2m << 1);
            --base10x;
        }
        long base10m = MicroDouble.dpMul(base2m, pow2m[idx]);
        boolean roundedUp = false;
        while (true) {
            int r = (int)(base10m % 10L);
            long mt = base10m / 10L;
            int xt = base10x + 1;
            if (r != 0) {
                boolean rut;
                if (r > 5 || r == 5 && !roundedUp) {
                    rut = true;
                    ++mt;
                } else {
                    rut = false;
                }
                long dt = MicroDouble.decToDouble(n, xt, mt);
                if (dt != d) {
                    mt = rut ? --mt : ++mt;
                    rut ^= true;
                    dt = MicroDouble.decToDouble(n, xt, mt);
                    if (dt != d) break;
                }
                roundedUp = rut;
            }
            base10m = mt;
            base10x = xt;
        }
        String s;
        block2: while ((s = MicroDouble.toString(n, base10x, base10m)).length() > maxStringLength) {
            int r = (int)(base10m % 10L);
            base10m /= 10L;
            ++base10x;
            if (r > 5 || r == 5 && !roundedUp) {
                roundedUp = true;
                ++base10m;
            } else {
                roundedUp = false;
            }
            while (true) {
                if (base10m % 10L != 0L) continue block2;
                base10m /= 10L;
                ++base10x;
            }
            break;
        }
        return s;
    }

    private static String toString(boolean negative, int base10x, long base10m) {
        int i;
        int dp;
        String s;
        boolean scientific;
        StringBuffer sb = new StringBuffer(26);
        if (negative) {
            sb.append('-');
        }
        boolean bl = scientific = (base10x += (s = Long.toString(base10m)).length() - 1) < -3 || base10x >= 7;
        if (scientific) {
            dp = 1;
        } else {
            dp = base10x + 1;
            if (dp < 1) {
                sb.append('0');
            }
        }
        for (i = 0; i < dp; ++i) {
            if (i < s.length()) {
                sb.append(s.charAt(i));
                continue;
            }
            sb.append('0');
        }
        sb.append('.');
        if (dp >= s.length()) {
            sb.append('0');
        } else {
            for (i = dp; i < s.length(); ++i) {
                if (i < 0) {
                    sb.append('0');
                    continue;
                }
                sb.append(s.charAt(i));
            }
        }
        if (scientific) {
            sb.append('E');
            sb.append(Integer.toString(base10x));
        }
        return sb.toString();
    }

    public static long toDegrees(long angrad) {
        return MicroDouble.div(MicroDouble.mul(angrad, 4640537203540230144L), 4614256656552045848L);
    }

    public static long toRadians(long angdeg) {
        return MicroDouble.mul(MicroDouble.div(angdeg, 4640537203540230144L), 4614256656552045848L);
    }

    public static long toGradians(long angrad) {
        return MicroDouble.div(MicroDouble.mul(angrad, 4641240890982006784L), 4614256656552045848L);
    }

    public static long gradiansToRadians(long anggrad) {
        return MicroDouble.mul(MicroDouble.div(anggrad, 4641240890982006784L), 4614256656552045848L);
    }

    private static long set(int newHiPart, int newLowPart) {
        return (long)newHiPart << 32 | (long)newLowPart;
    }

    private static long setLO(long d, int newLowPart) {
        return d & 0xFFFFFFFF00000000L | (long)newLowPart;
    }

    private static long setHI(long d, int newHiPart) {
        return d & 0xFFFFFFFFL | (long)newHiPart << 32;
    }

    private static int getHI(long d) {
        return (int)(d >> 32);
    }

    private static int getLO(long d) {
        return (int)d;
    }

    private static int ilogb(long d) {
        if (MicroDouble.isZero(d)) {
            return -2147483647;
        }
        if (MicroDouble.isNaN(d) || MicroDouble.isInfinite(d)) {
            return Integer.MAX_VALUE;
        }
        int x = (int)(d >> 52) & 0x7FF;
        if (x == 0) {
            long m = d & 0xFFFFFFFFFFFFFL;
            while (m < 0x10000000000000L) {
                m <<= 1;
                --x;
            }
        }
        return x - 1023;
    }

    private static long copySign(long x, long y) {
        return x & Long.MAX_VALUE | y & Long.MIN_VALUE;
    }

    public static long scalbn(long d, int n) {
        if (MicroDouble.isNaN(d)) {
            return 9221120237041090560L;
        }
        if (n == 0 || MicroDouble.isInfinite(d) || MicroDouble.isZero(d)) {
            return d;
        }
        if (n >= 2098) {
            return MicroDouble.copySign(0x7FF0000000000000L, d);
        }
        if (n <= -2099) {
            return MicroDouble.copySign(0L, d);
        }
        int x = (int)(d >> 52) & 0x7FF;
        int x2 = x + n;
        if (x == 0 || x2 <= 0) {
            return MicroDouble.pack(MicroDouble.unpackSign(d), x2 - 1075, MicroDouble.unpackMantissa(d));
        }
        if (x2 >= 2047) {
            return MicroDouble.copySign(0x7FF0000000000000L, d);
        }
        return d & 0x800FFFFFFFFFFFFFL | (long)x2 << 52;
    }

    public static long IEEEremainder(long d1, long d2) {
        if (MicroDouble.isNaN(d1) || MicroDouble.isNaN(d2) || MicroDouble.isInfinite(d1) || MicroDouble.isZero(d2)) {
            return 9221120237041090560L;
        }
        if (MicroDouble.isZero(d1) || MicroDouble.isInfinite(d2)) {
            return d1;
        }
        int hx = MicroDouble.getHI(d1);
        int lx = MicroDouble.getLO(d1);
        int hp = MicroDouble.getHI(d2);
        int lp = MicroDouble.getLO(d2);
        boolean negative = MicroDouble.unpackSign(d1);
        hx &= Integer.MAX_VALUE;
        if ((hp &= Integer.MAX_VALUE) <= 0x7FDFFFFF) {
            d1 = MicroDouble.mod(d1, MicroDouble.scalbn(d2, 1));
        }
        if ((hx - hp | lx - lp) == 0) {
            return 0L;
        }
        d1 = MicroDouble.abs(d1);
        d2 = MicroDouble.abs(d2);
        if (hp < 0x200000) {
            if (MicroDouble.gt(MicroDouble.scalbn(d1, 1), d2) && MicroDouble.ge(MicroDouble.scalbn(d1 = MicroDouble.sub(d1, d2), 1), d2)) {
                d1 = MicroDouble.sub(d1, d2);
            }
        } else {
            long p_half = MicroDouble.scalbn(d2, -1);
            if (MicroDouble.gt(d1, p_half) && MicroDouble.ge(d1 = MicroDouble.sub(d1, d2), p_half)) {
                d1 = MicroDouble.sub(d1, d2);
            }
        }
        if (negative) {
            return MicroDouble.negate(d1);
        }
        return d1;
    }

    public static long sqrt(long d) {
        if (MicroDouble.isZero(d)) {
            return d;
        }
        if (MicroDouble.unpackSign(d) || MicroDouble.isNaN(d)) {
            return 9221120237041090560L;
        }
        if (d == 0x7FF0000000000000L) {
            return d;
        }
        int x = MicroDouble.unpackExponent(d);
        long m = MicroDouble.unpackMantissa(d);
        while (m < 0x10000000000000L) {
            m <<= 1;
            --x;
        }
        if ((x & 1) != 0) {
            m <<= 1;
        }
        x = (x >> 1) - 26;
        m <<= 1;
        long q = 0L;
        long s = 0L;
        for (long r = 0x20000000000000L; r != 0L; r >>= 1) {
            long t = s + r;
            if (t < m) {
                s = t + r;
                m -= t;
                q |= r;
            }
            m <<= 1;
        }
        if (m != 0L) {
            q += q & 1L;
        }
        return (long)x + 1075L << 52 | (q >>= 1) & 0xFFFFFFFFFFFFFL;
    }

    public static long exp(long d) {
        long t;
        long x = d;
        if (MicroDouble.isNaN(x)) {
            return 9221120237041090560L;
        }
        if (MicroDouble.isZero(x)) {
            return 0x3FF0000000000000L;
        }
        if (MicroDouble.le(x, -4573606559926636463L)) {
            return 0L;
        }
        if (MicroDouble.ge(x, 4649454530587146735L)) {
            return 0x7FF0000000000000L;
        }
        long hi = 0L;
        long lo = 0L;
        int k = 0;
        int hx = MicroDouble.getHI(x) & Integer.MAX_VALUE;
        if (hx > 1071001154) {
            if (hx < 1072734898) {
                if (MicroDouble.unpackSign(x)) {
                    hi = MicroDouble.add(x, 4604418534311723008L);
                    lo = -4761929956433773450L;
                    k = -1;
                } else {
                    hi = MicroDouble.sub(x, 4604418534311723008L);
                    lo = 4461442080421002358L;
                    k = 1;
                }
            } else {
                t = MicroDouble.rint(MicroDouble.mul(4609176140021203710L, x));
                k = MicroDouble.intValue(t);
                hi = MicroDouble.sub(x, MicroDouble.mul(t, 4604418534311723008L));
                lo = MicroDouble.mul(t, 4461442080421002358L);
            }
            x = MicroDouble.sub(hi, lo);
        } else {
            if (hx < 0x3E300000) {
                return MicroDouble.add(x, 0x3FF0000000000000L);
            }
            k = 0;
        }
        t = MicroDouble.mul(x, x);
        long c = MicroDouble.sub(x, MicroDouble.mul(t, MicroDouble.add(4595172819793696062L, MicroDouble.mul(t, MicroDouble.add(-4654820494858601069L, MicroDouble.mul(t, MicroDouble.add(4544508515198557740L, MicroDouble.mul(t, MicroDouble.add(-4702957295668925455L, MicroDouble.mul(t, 4496342204012209360L))))))))));
        if (k == 0) {
            return MicroDouble.sub(0x3FF0000000000000L, MicroDouble.sub(MicroDouble.div(MicroDouble.mul(x, c), MicroDouble.sub(c, 0x4000000000000000L)), x));
        }
        x = MicroDouble.sub(0x3FF0000000000000L, MicroDouble.sub(MicroDouble.sub(lo, MicroDouble.div(MicroDouble.mul(x, c), MicroDouble.sub(0x4000000000000000L, c))), hi));
        return MicroDouble.scalbn(x, k);
    }

    public static long expm1(long d) {
        long c;
        int k;
        int hx = MicroDouble.getHI(d);
        int xsb = hx & Integer.MIN_VALUE;
        long y = xsb == 0 ? d : -d;
        if ((hx &= Integer.MAX_VALUE) >= 1078159482) {
            if (hx >= 1082535490) {
                if (hx >= 0x7FF00000) {
                    if ((hx & 0xFFFFF | MicroDouble.getLO(d)) != 0) {
                        return 9221120237041090560L;
                    }
                    return xsb == 0 ? d : -4616189618054758400L;
                }
                if (d > 4649454530587146735L) {
                    return 0x7FF0000000000000L;
                }
            }
            if (xsb != 0) {
                return -4616189618054758400L;
            }
        }
        if (hx > 1071001154) {
            long lo;
            long hi;
            if (hx < 1072734898) {
                if (xsb == 0) {
                    hi = MicroDouble.sub(d, 4604418534311723008L);
                    lo = 4461442080421002358L;
                    k = 1;
                } else {
                    hi = MicroDouble.add(d, 4604418534311723008L);
                    lo = MicroDouble.negate(4461442080421002358L);
                    k = -1;
                }
            } else {
                long tmp = MicroDouble.mul(4609176140021203710L, d);
                tmp = xsb == 0 ? MicroDouble.add(tmp, 4602678819172646912L) : MicroDouble.sub(tmp, 4602678819172646912L);
                k = MicroDouble.intValue(MicroDouble.add(MicroDouble.mul(4609176140021203710L, d), xsb == 0 ? 4602678819172646912L : MicroDouble.negate(4602678819172646912L)));
                long t = MicroDouble.intToDouble(k);
                hi = MicroDouble.sub(d, MicroDouble.mul(t, 4604418534311723008L));
                lo = MicroDouble.mul(t, 4461442080421002358L);
            }
            d = MicroDouble.sub(hi, lo);
            c = MicroDouble.sub(MicroDouble.sub(hi, d), lo);
        } else {
            if (hx < 1016070144) {
                return d;
            }
            k = 0;
            c = 0L;
        }
        long hfx = MicroDouble.scalbn(d, -1);
        long hxs = MicroDouble.mul(d, hfx);
        long r1 = MicroDouble.add(0x3FF0000000000000L, MicroDouble.mul(hxs, MicroDouble.add(-4638407376216452876L, MicroDouble.mul(hxs, MicroDouble.add(4564962959435912581L, MicroDouble.mul(hxs, MicroDouble.add(-4677887503499600969L, MicroDouble.mul(hxs, MicroDouble.add(4526346094260933177L, MicroDouble.mul(hxs, -4716678695450197203L))))))))));
        long t = MicroDouble.sub(0x4008000000000000L, MicroDouble.mul(r1, hfx));
        long e = MicroDouble.mul(hxs, MicroDouble.div(MicroDouble.sub(r1, t), MicroDouble.sub(4618441417868443648L, MicroDouble.mul(d, t))));
        if (k == 0) {
            return MicroDouble.sub(d, MicroDouble.sub(MicroDouble.mul(d, e), hxs));
        }
        e = MicroDouble.sub(MicroDouble.sub(MicroDouble.mul(d, MicroDouble.sub(e, c)), c), hxs);
        if (k == -1) {
            return MicroDouble.sub(MicroDouble.scalbn(MicroDouble.sub(d, e), -1), 4602678819172646912L);
        }
        if (k == 1) {
            if (MicroDouble.lt(d, MicroDouble.negate(4598175219545276416L))) {
                return MicroDouble.negate(MicroDouble.scalbn(MicroDouble.sub(e, MicroDouble.add(d, 4602678819172646912L)), 1));
            }
            return MicroDouble.add(0x3FF0000000000000L, MicroDouble.scalbn(MicroDouble.sub(d, e), 1));
        }
        if (k <= -2 || k > 56) {
            y = MicroDouble.sub(0x3FF0000000000000L, MicroDouble.sub(e, d));
            y = MicroDouble.setHI(y, MicroDouble.getHI(y) + (k << 20));
            return MicroDouble.sub(y, 0x3FF0000000000000L);
        }
        t = 0x3FF0000000000000L;
        if (k < 20) {
            t = MicroDouble.setHI(t, 0x3FF00000 - (0x200000 >> k));
            y = MicroDouble.sub(t, MicroDouble.sub(e, d));
            y = MicroDouble.setHI(y, MicroDouble.getHI(y) + (k << 20));
        } else {
            t = MicroDouble.setHI(t, 1023 - k << 20);
            y = MicroDouble.add(MicroDouble.sub(d, MicroDouble.add(e, t)), 0x3FF0000000000000L);
            y = MicroDouble.setHI(y, MicroDouble.getHI(y) + (k << 20));
        }
        return y;
    }

    public static long pow(long d1, long d2) {
        long t;
        long t2;
        long t1;
        boolean negative;
        if (MicroDouble.isZero(d2)) {
            return 0x3FF0000000000000L;
        }
        if (MicroDouble.isNaN(d1) || MicroDouble.isNaN(d2)) {
            return 9221120237041090560L;
        }
        int i0 = -8388607;
        int i1 = 1 - i0;
        int hx = MicroDouble.getHI(d1);
        int lx = MicroDouble.getLO(d1);
        int hy = MicroDouble.getHI(d2);
        int ly = MicroDouble.getLO(d2);
        int ix = hx & Integer.MAX_VALUE;
        int iy = hy & Integer.MAX_VALUE;
        int yisint = 0;
        if (hx < 0) {
            if (iy >= 0x43400000) {
                yisint = 2;
            } else if (iy >= 0x3FF00000) {
                int j;
                int k = (iy >> 20) - 1023;
                if (k > 20) {
                    int j2 = ly >>> 52 - k;
                    if (j2 << 52 - k == ly) {
                        yisint = 2 - (j2 & 1);
                    }
                } else if (ly == 0 && (j = iy >> 20 - k) << 20 - k == iy) {
                    yisint = 2 - (j & 1);
                }
            }
        }
        if (ly == 0) {
            if (iy == 0x7FF00000) {
                if ((ix - 0x3FF00000 | lx) == 0) {
                    return 9221120237041090560L;
                }
                if (ix >= 0x3FF00000) {
                    return hy >= 0 ? 0x7FF0000000000000L : 0L;
                }
                return hy < 0 ? 0x7FF0000000000000L : 0L;
            }
            if (iy == 0x3FF00000) {
                if (hy < 0) {
                    return MicroDouble.div(0x3FF0000000000000L, d1);
                }
                return d1;
            }
            if (hy == 0x40000000) {
                return MicroDouble.mul(d1, d1);
            }
            if (hy == 1071644672 && hx >= 0) {
                return MicroDouble.sqrt(d1);
            }
        }
        long ax = MicroDouble.abs(d1);
        if (lx == 0 && (ix == 0x7FF00000 || ix == 0 || ix == 0x3FF00000)) {
            long z = ax;
            if (hy < 0) {
                z = MicroDouble.div(0x3FF0000000000000L, z);
            }
            if (hx < 0) {
                if ((ix - 0x3FF00000 | yisint) == 0) {
                    z = 9221120237041090560L;
                } else if (yisint == 1) {
                    z = MicroDouble.negate(z);
                }
            }
            return z;
        }
        int n = (hx >> 31) + 1;
        if ((n | yisint) == 0) {
            return 9221120237041090560L;
        }
        boolean bl = negative = (n | yisint - 1) == 0;
        if (iy > 1105199104) {
            if (iy > 1139802112) {
                if (ix <= 0x3FEFFFFF) {
                    return hy < 0 ? 0x7FF0000000000000L : 0L;
                }
                return hy > 0 ? 0x7FF0000000000000L : 0L;
            }
            if (ix < 0x3FEFFFFF) {
                if (negative) {
                    return hy < 0 ? -4503599627370496L : Long.MIN_VALUE;
                }
                return hy < 0 ? 0x7FF0000000000000L : 0L;
            }
            if (ix > 0x3FF00000) {
                if (negative) {
                    return hy > 0 ? -4503599627370496L : Long.MIN_VALUE;
                }
                return hy > 0 ? 0x7FF0000000000000L : 0L;
            }
            long t3 = MicroDouble.sub(ax, 0x3FF0000000000000L);
            long w = MicroDouble.mul(MicroDouble.mul(t3, t3), MicroDouble.sub(4602678819172646912L, MicroDouble.mul(t3, MicroDouble.sub(4599676419421066581L, MicroDouble.mul(t3, 4598175219545276416L)))));
            long u = MicroDouble.mul(4609176139934466048L, t3);
            long v = MicroDouble.sub(MicroDouble.mul(t3, 4491406094830001988L), MicroDouble.mul(w, 4609176140021203710L));
            t1 = MicroDouble.setLO(MicroDouble.add(u, v), 0);
            t2 = MicroDouble.sub(v, MicroDouble.sub(t1, u));
        } else {
            int k;
            n = 0;
            if (ix < 0x100000) {
                ax = MicroDouble.scalbn(ax, 53);
                n -= 53;
                ix = MicroDouble.getHI(ax);
            }
            n += (ix >> 20) - 1023;
            int j = ix & 0xFFFFF;
            ix = j | 0x3FF00000;
            if (j <= 235662) {
                k = 0;
            } else if (j < 767610) {
                k = 1;
            } else {
                k = 0;
                ++n;
                ix -= 0x100000;
            }
            ax = MicroDouble.setHI(ax, ix);
            long u = MicroDouble.sub(ax, BP[k]);
            long v = MicroDouble.div(0x3FF0000000000000L, MicroDouble.add(ax, BP[k]));
            long ss = MicroDouble.mul(u, v);
            long s_h = MicroDouble.setLO(ss, 0);
            long t_h = MicroDouble.setHI(0L, (ix >> 1 | 0x20000000) + 524288 + (k << 18));
            long t_l = MicroDouble.sub(ax, MicroDouble.sub(t_h, BP[k]));
            long s_l = MicroDouble.mul(v, MicroDouble.sub(MicroDouble.sub(u, MicroDouble.mul(s_h, t_h)), MicroDouble.mul(s_h, t_l)));
            long s2 = MicroDouble.mul(ss, ss);
            long r = MicroDouble.mul(MicroDouble.mul(s2, s2), MicroDouble.add(4603579539098120963L, MicroDouble.mul(s2, MicroDouble.add(4601392076422097919L, MicroDouble.mul(s2, MicroDouble.add(4599676419357746765L, MicroDouble.mul(s2, MicroDouble.add(4598584653024936193L, MicroDouble.mul(s2, MicroDouble.add(4597478449480325989L, MicroDouble.mul(s2, 4596625081194860271L)))))))))));
            r = MicroDouble.add(r, MicroDouble.mul(s_l, MicroDouble.add(s_h, ss)));
            s2 = MicroDouble.mul(s_h, s_h);
            t_h = MicroDouble.setLO(MicroDouble.add(MicroDouble.add(0x4008000000000000L, s2), r), 0);
            t_l = MicroDouble.sub(r, MicroDouble.sub(MicroDouble.sub(t_h, 0x4008000000000000L), s2));
            u = MicroDouble.mul(s_h, t_h);
            v = MicroDouble.add(MicroDouble.mul(s_l, t_h), MicroDouble.mul(t_l, ss));
            long p_h = MicroDouble.setLO(MicroDouble.add(u, v), 0);
            long p_l = MicroDouble.sub(v, MicroDouble.sub(p_h, u));
            long z_h = MicroDouble.mul(4606838314073325568L, p_h);
            long z_l = MicroDouble.add(MicroDouble.add(MicroDouble.mul(-4738297118486494731L, p_h), MicroDouble.mul(p_l, 4606838314010018813L)), DP_LO[k]);
            long t4 = MicroDouble.intToDouble(n);
            t1 = MicroDouble.setLO(MicroDouble.add(MicroDouble.add(MicroDouble.add(z_h, z_l), DP_HI[k]), t4), 0);
            t2 = MicroDouble.sub(z_l, MicroDouble.sub(MicroDouble.sub(MicroDouble.sub(t1, t4), DP_HI[k]), z_h));
        }
        long y1 = MicroDouble.setLO(d2, 0);
        long p_l = MicroDouble.add(MicroDouble.mul(MicroDouble.sub(d2, y1), t1), MicroDouble.mul(d2, t2));
        long p_h = MicroDouble.mul(y1, t1);
        long z = MicroDouble.add(p_l, p_h);
        int j = MicroDouble.getHI(z);
        int i = MicroDouble.getLO(z);
        if (j >= 0x40900000) {
            if ((j - 0x40900000 | i) != 0 || MicroDouble.gt(MicroDouble.add(p_l, 4365981760143196926L), MicroDouble.sub(z, p_h))) {
                return negative ? -4503599627370496L : 0x7FF0000000000000L;
            }
        } else if ((j & Integer.MAX_VALUE) >= 1083231232 && ((j - -1064252416 | i) != 0 || MicroDouble.le(p_l, MicroDouble.sub(z, p_h)))) {
            return negative ? Long.MIN_VALUE : 0L;
        }
        i = j & Integer.MAX_VALUE;
        int k = (i >> 20) - 1023;
        n = 0;
        if (i > 1071644672) {
            n = j + (0x100000 >> k + 1);
            k = ((n & Integer.MAX_VALUE) >> 20) - 1023;
            t = 0L;
            t = MicroDouble.setHI(t, n & ~(1048575 >> k));
            n = (n & 0xFFFFF | 0x100000) >> 20 - k;
            if (j < 0) {
                n = -n;
            }
            p_h = MicroDouble.sub(p_h, t);
        }
        t = MicroDouble.setLO(MicroDouble.add(p_l, p_h), 0);
        long u = MicroDouble.mul(t, 4604418534330597376L);
        long v = MicroDouble.add(MicroDouble.mul(MicroDouble.sub(p_l, MicroDouble.sub(t, p_h)), 4604418534313441775L), MicroDouble.mul(t, -4746692435354555335L));
        z = MicroDouble.add(u, v);
        long w = MicroDouble.sub(v, MicroDouble.sub(z, u));
        t = MicroDouble.mul(z, z);
        t1 = MicroDouble.sub(z, MicroDouble.mul(t, MicroDouble.add(4595172819793696062L, MicroDouble.mul(t, MicroDouble.add(-4654820494858601069L, MicroDouble.mul(t, MicroDouble.add(4544508515198557740L, MicroDouble.mul(t, MicroDouble.add(-4702957295668925455L, MicroDouble.mul(t, 4496342204012209360L))))))))));
        long r = MicroDouble.sub(MicroDouble.div(MicroDouble.mul(z, t1), MicroDouble.sub(t1, 0x4000000000000000L)), MicroDouble.add(w, MicroDouble.mul(z, w)));
        z = MicroDouble.sub(0x3FF0000000000000L, MicroDouble.sub(r, z));
        j = MicroDouble.getHI(z);
        if ((j += n << 20) >> 20 <= 0) {
            z = MicroDouble.scalbn(z, n);
        } else {
            i = MicroDouble.getHI(z);
            z = MicroDouble.setHI(z, i += n << 20);
        }
        if (negative) {
            z = MicroDouble.negate(z);
        }
        return z;
    }

    public static long log(long d, long base) {
        if (base == 4613303445314885481L) {
            return MicroDouble.log(d);
        }
        if (base == 0x4024000000000000L) {
            return MicroDouble.log10(d);
        }
        if (MicroDouble.isZero(base) || MicroDouble.isInfinite(base) || MicroDouble.isNaN(base) || MicroDouble.unpackSign(base)) {
            return 9221120237041090560L;
        }
        return MicroDouble.div(MicroDouble.log(d), MicroDouble.log(base));
    }

    public static long log10(long d) {
        if (MicroDouble.isZero(d)) {
            return -4503599627370496L;
        }
        if (MicroDouble.isNaN(d) || MicroDouble.unpackSign(d)) {
            return 9221120237041090560L;
        }
        if (d == 0x7FF0000000000000L) {
            return d;
        }
        int n = MicroDouble.ilogb(d);
        if (n < 0) {
            ++n;
        }
        d = MicroDouble.scalbn(d, -n);
        long dn = MicroDouble.intToDouble(n);
        return MicroDouble.add(MicroDouble.mul(dn, 4599094494223097856L), MicroDouble.add(MicroDouble.mul(dn, 4420844829172378422L), MicroDouble.mul(4601495173785380110L, MicroDouble.log(d))));
    }

    public static long log(long d) {
        if (MicroDouble.isZero(d)) {
            return -4503599627370496L;
        }
        if (MicroDouble.isNaN(d) || MicroDouble.unpackSign(d)) {
            return 9221120237041090560L;
        }
        if (d == 0x7FF0000000000000L) {
            return d;
        }
        int hx = MicroDouble.getHI(d);
        int k = 0;
        if (hx < 0x100000) {
            k -= 54;
            d = MicroDouble.scalbn(d, 54);
            hx = MicroDouble.getHI(d);
        }
        k += (hx >> 20) - 1023;
        int i = (hx &= 0xFFFFF) + 614244 & 0x100000;
        d = MicroDouble.setHI(d, hx | i ^ 0x3FF00000);
        k += i >> 20;
        long f = MicroDouble.sub(d, 0x3FF0000000000000L);
        if ((0xFFFFF & 2 + hx) < 3) {
            if (MicroDouble.isZero(f)) {
                if (k == 0) {
                    return 0L;
                }
                long dk = MicroDouble.intToDouble(k);
                return MicroDouble.add(MicroDouble.mul(dk, 4604418534311723008L), MicroDouble.mul(dk, 4461442080421002358L));
            }
            long R = MicroDouble.mul(MicroDouble.mul(f, f), MicroDouble.sub(4602678819172646912L, MicroDouble.mul(4599676419421066581L, f)));
            if (k == 0) {
                return MicroDouble.sub(f, R);
            }
            long dk = MicroDouble.intToDouble(k);
            return MicroDouble.sub(MicroDouble.mul(dk, 4604418534311723008L), MicroDouble.sub(MicroDouble.sub(R, MicroDouble.mul(dk, 4461442080421002358L)), f));
        }
        long dk = MicroDouble.intToDouble(k);
        long s = MicroDouble.div(f, MicroDouble.add(0x4000000000000000L, f));
        long z = MicroDouble.mul(s, s);
        long w = MicroDouble.mul(z, z);
        long R = MicroDouble.add(MicroDouble.mul(w, MicroDouble.add(4600877379321592324L, MicroDouble.mul(w, MicroDouble.add(4597174411056806063L, MicroDouble.mul(w, 4594685411790997151L))))), MicroDouble.mul(z, MicroDouble.add(4604180019048437139L, MicroDouble.mul(w, MicroDouble.add(4598818590951641945L, MicroDouble.mul(w, MicroDouble.add(4595719342595441630L, MicroDouble.mul(w, 4594499633228436036L))))))));
        i = hx - 398458 | 440401 - hx;
        if (i > 0) {
            long hfsq = MicroDouble.mul(MicroDouble.scalbn(f, -1), f);
            if (k == 0) {
                return MicroDouble.sub(f, MicroDouble.sub(hfsq, MicroDouble.mul(s, MicroDouble.add(hfsq, R))));
            }
            return MicroDouble.sub(MicroDouble.mul(dk, 4604418534311723008L), MicroDouble.sub(MicroDouble.sub(hfsq, MicroDouble.add(MicroDouble.mul(s, MicroDouble.add(hfsq, R)), MicroDouble.mul(dk, 4461442080421002358L))), f));
        }
        if (k == 0) {
            return MicroDouble.sub(f, MicroDouble.mul(s, MicroDouble.sub(f, R)));
        }
        return MicroDouble.sub(MicroDouble.mul(dk, 4604418534311723008L), MicroDouble.sub(MicroDouble.sub(MicroDouble.mul(s, MicroDouble.sub(f, R)), MicroDouble.mul(dk, 4461442080421002358L)), f));
    }

    public static long log1p(long d) {
        int hx = MicroDouble.getHI(d);
        int ax = hx & Integer.MAX_VALUE;
        int k = 1;
        int hu = 0;
        long f = 0L;
        if (hx < 1071284858) {
            if (ax >= 0x3FF00000) {
                if (d == -4616189618054758400L) {
                    return -4503599627370496L;
                }
                return 9221120237041090560L;
            }
            if (ax < 1042284544) {
                if (ax < 1016070144) {
                    return d;
                }
                return MicroDouble.sub(d, MicroDouble.scalbn(MicroDouble.mul(d, d), -1));
            }
            if (hx > 0 || hx <= -1076707645) {
                k = 0;
                f = d;
                hu = 1;
            }
        }
        if (hx >= 0x7FF00000) {
            return d;
        }
        long c = 0L;
        if (k != 0) {
            long u;
            if (hx < 0x43400000) {
                u = MicroDouble.add(0x3FF0000000000000L, d);
                hu = MicroDouble.getHI(u);
                k = (hu >> 20) - 1023;
                c = k > 0 ? MicroDouble.sub(0x3FF0000000000000L, MicroDouble.sub(u, d)) : MicroDouble.sub(d, MicroDouble.sub(u, 0x3FF0000000000000L));
                c = MicroDouble.div(c, u);
            } else {
                u = d;
                hu = MicroDouble.getHI(u);
                k = (hu >> 20) - 1023;
                c = 0L;
            }
            if ((hu &= 0xFFFFF) < 434334) {
                u = MicroDouble.setHI(u, hu | 0x3FF00000);
            } else {
                ++k;
                u = MicroDouble.setHI(u, hu | 0x3FE00000);
                hu = 0x100000 - hu >> 2;
            }
            f = MicroDouble.add(u, -4616189618054758400L);
        }
        long hfsq = MicroDouble.scalbn(MicroDouble.mul(f, f), -1);
        long dk = MicroDouble.intToDouble(k);
        if (hu == 0) {
            if (MicroDouble.isZero(f)) {
                if (k == 0) {
                    return 0L;
                }
                c = MicroDouble.add(c, MicroDouble.mul(dk, 4461442080421002358L));
                return MicroDouble.add(MicroDouble.mul(dk, 4604418534311723008L), c);
            }
            long R = MicroDouble.mul(hfsq, MicroDouble.sub(0x3FF0000000000000L, MicroDouble.div(MicroDouble.scalbn(f, 2), 0x4008000000000000L)));
            if (k == 0) {
                return MicroDouble.sub(f, R);
            }
            return MicroDouble.sub(MicroDouble.mul(dk, 4604418534311723008L), MicroDouble.sub(MicroDouble.sub(R, MicroDouble.add(MicroDouble.mul(dk, 4461442080421002358L), c)), f));
        }
        long s = MicroDouble.div(f, MicroDouble.add(0x4000000000000000L, f));
        long z = MicroDouble.mul(s, s);
        long R = MicroDouble.mul(z, MicroDouble.add(4604180019048437139L, MicroDouble.mul(z, MicroDouble.add(4600877379321592324L, MicroDouble.mul(z, MicroDouble.add(4598818590951641945L, MicroDouble.mul(z, MicroDouble.add(4597174411056806063L, MicroDouble.mul(z, MicroDouble.add(4595719342595441630L, MicroDouble.mul(z, MicroDouble.add(4594685411790997151L, MicroDouble.mul(z, 4594499633228436036L)))))))))))));
        if (k == 0) {
            return MicroDouble.sub(f, MicroDouble.sub(hfsq, MicroDouble.mul(s, MicroDouble.add(hfsq, R))));
        }
        return MicroDouble.sub(MicroDouble.mul(dk, 4604418534311723008L), MicroDouble.sub(MicroDouble.sub(hfsq, MicroDouble.add(MicroDouble.mul(s, MicroDouble.add(hfsq, R)), MicroDouble.add(MicroDouble.mul(dk, 4461442080421002358L), c))), f));
    }

    public static long sin(long d) {
        int ix = MicroDouble.getHI(d) & Integer.MAX_VALUE;
        if (ix <= 1072243195) {
            return MicroDouble.kernelSin(d, 0L, 0);
        }
        if (ix >= 0x7FF00000) {
            return 9221120237041090560L;
        }
        long[] y = new long[2];
        int n = MicroDouble.remPio2(d, y);
        switch (n & 3) {
            case 0: {
                return MicroDouble.kernelSin(y[0], y[1], 1);
            }
            case 1: {
                return MicroDouble.kernelCos(y[0], y[1]);
            }
            case 2: {
                return MicroDouble.negate(MicroDouble.kernelSin(y[0], y[1], 1));
            }
        }
        return MicroDouble.negate(MicroDouble.kernelCos(y[0], y[1]));
    }

    public static long cos(long d) {
        int ix = MicroDouble.getHI(d) & Integer.MAX_VALUE;
        if (ix <= 1072243195) {
            return MicroDouble.kernelCos(d, 0L);
        }
        if (ix >= 0x7FF00000) {
            return 9221120237041090560L;
        }
        long[] y = new long[2];
        int n = MicroDouble.remPio2(d, y);
        switch (n & 3) {
            case 0: {
                return MicroDouble.kernelCos(y[0], y[1]);
            }
            case 1: {
                return MicroDouble.negate(MicroDouble.kernelSin(y[0], y[1], 1));
            }
            case 2: {
                return MicroDouble.negate(MicroDouble.kernelCos(y[0], y[1]));
            }
        }
        return MicroDouble.kernelSin(y[0], y[1], 1);
    }

    public static long tan(long d) {
        int ix = MicroDouble.getHI(d) & Integer.MAX_VALUE;
        if (ix <= 1072243195) {
            return MicroDouble.kernelTan(d, 0L, 1);
        }
        if (ix >= 0x7FF00000) {
            return 9221120237041090560L;
        }
        long[] y = new long[2];
        int n = MicroDouble.remPio2(d, y);
        return MicroDouble.kernelTan(y[0], y[1], 1 - ((n & 1) << 1));
    }

    private static long kernelTan(long x, long y, int iy) {
        int hx = MicroDouble.getHI(x);
        int ix = hx & Integer.MAX_VALUE;
        if (ix < 0x3E300000 && MicroDouble.intValue(x) == 0) {
            if ((ix | MicroDouble.getLO(x) | iy + 1) == 0) {
                return 0x7FF0000000000000L;
            }
            if (iy == 1) {
                return x;
            }
            long w = MicroDouble.add(x, y);
            long z = MicroDouble.setLO(w, 0);
            long v = MicroDouble.sub(y, MicroDouble.sub(z, x));
            long a = MicroDouble.div(-4616189618054758400L, w);
            long t = MicroDouble.setLO(a, 0);
            long s = MicroDouble.add(0x3FF0000000000000L, MicroDouble.mul(t, z));
            return MicroDouble.add(t, MicroDouble.mul(a, MicroDouble.add(s, MicroDouble.mul(t, v))));
        }
        if (ix >= 1072010280) {
            if (hx < 0) {
                x = MicroDouble.negate(x);
                y = MicroDouble.negate(y);
            }
            x = MicroDouble.add(MicroDouble.sub(4605249457297304856L, x), MicroDouble.sub(4359948597267291143L, y));
            y = 0L;
        }
        long z = MicroDouble.mul(x, x);
        long w = MicroDouble.mul(z, z);
        long r = MicroDouble.add(4593971859893059194L, MicroDouble.mul(w, MicroDouble.add(4581960672245896759L, MicroDouble.mul(w, MicroDouble.add(4570429193025094440L, MicroDouble.mul(w, MicroDouble.add(4558562946408670465L, MicroDouble.mul(w, MicroDouble.add(4545397049192321702L, MicroDouble.mul(w, -4687273268743220365L))))))))));
        long v = MicroDouble.mul(z, MicroDouble.add(4587938466107703806L, MicroDouble.mul(w, MicroDouble.add(4576262931677611155L, MicroDouble.mul(w, MicroDouble.add(4564358403679355669L, MicroDouble.mul(w, MicroDouble.add(4553182066015801448L, MicroDouble.mul(w, MicroDouble.add(4544897349388904425L, MicroDouble.mul(w, 4538267711989316308L)))))))))));
        long s = MicroDouble.mul(z, x);
        r = MicroDouble.add(MicroDouble.add(y, MicroDouble.mul(z, MicroDouble.add(MicroDouble.mul(s, MicroDouble.add(r, v)), y))), MicroDouble.mul(4599676419421066595L, s));
        w = MicroDouble.add(x, r);
        if (ix >= 1072010280) {
            v = MicroDouble.intToDouble(iy);
            return MicroDouble.mul(MicroDouble.intToDouble(1 - (hx >> 30 & 2)), MicroDouble.sub(v, MicroDouble.mul(0x4000000000000000L, MicroDouble.sub(x, MicroDouble.sub(MicroDouble.div(MicroDouble.mul(w, w), MicroDouble.add(w, v)), r)))));
        }
        if (iy == 1) {
            return w;
        }
        z = MicroDouble.setLO(w, 0);
        v = MicroDouble.sub(r, MicroDouble.sub(z, x));
        long a = MicroDouble.div(-4616189618054758400L, w);
        long t = MicroDouble.setLO(a, 0);
        s = MicroDouble.add(0x3FF0000000000000L, MicroDouble.mul(t, z));
        return MicroDouble.add(t, MicroDouble.mul(a, MicroDouble.add(s, MicroDouble.mul(t, v))));
    }

    private static long kernelSin(long x, long y, int iy) {
        int ix = MicroDouble.getHI(x) & Integer.MAX_VALUE;
        if (ix < 1044381696) {
            return x;
        }
        long z = MicroDouble.mul(x, x);
        long v = MicroDouble.mul(z, x);
        long r = MicroDouble.add(S2, MicroDouble.mul(z, MicroDouble.add(S3, MicroDouble.mul(z, MicroDouble.add(S4, MicroDouble.mul(z, MicroDouble.add(S5, MicroDouble.mul(z, S6))))))));
        if (iy == 0) {
            return MicroDouble.add(x, MicroDouble.mul(v, MicroDouble.add(S1, MicroDouble.mul(z, r))));
        }
        return MicroDouble.sub(x, MicroDouble.sub(MicroDouble.sub(MicroDouble.mul(z, MicroDouble.sub(MicroDouble.mul(4602678819172646912L, y), MicroDouble.mul(v, r))), y), MicroDouble.mul(v, S1)));
    }

    private static long kernelCos(long x, long y) {
        int ix = MicroDouble.getHI(x) & Integer.MAX_VALUE;
        if (ix < 1044381696) {
            return 0x3FF0000000000000L;
        }
        long z = MicroDouble.mul(x, x);
        long r = MicroDouble.mul(z, MicroDouble.add(4586165620538955084L, MicroDouble.mul(z, MicroDouble.add(-4659324094485802633L, MicroDouble.mul(z, MicroDouble.add(4537941361668330896L, MicroDouble.mul(z, MicroDouble.add(-4714566979978243411L, MicroDouble.mul(z, MicroDouble.add(4477121870137962948L, MicroDouble.mul(z, -4780295122622859052L)))))))))));
        if (ix < 0x3FD33333) {
            return MicroDouble.sub(0x3FF0000000000000L, MicroDouble.sub(MicroDouble.mul(4602678819172646912L, z), MicroDouble.sub(MicroDouble.mul(z, r), MicroDouble.mul(x, y))));
        }
        long qx = ix > 1072234496 ? 4598738169498697728L : MicroDouble.set(ix - 0x200000, 0);
        long hz = MicroDouble.sub(MicroDouble.mul(4602678819172646912L, z), qx);
        long a = MicroDouble.sub(0x3FF0000000000000L, qx);
        return MicroDouble.sub(a, MicroDouble.sub(hz, MicroDouble.sub(MicroDouble.mul(z, r), MicroDouble.mul(x, y))));
    }

    private static int remPio2(long x, long[] y) {
        int hx = MicroDouble.getHI(x);
        int ix = hx & Integer.MAX_VALUE;
        if (ix <= 1072243195) {
            y[0] = x;
            y[1] = 0L;
            return 0;
        }
        if (ix < 1073928572) {
            long b;
            long a = 4609753056924401664L;
            long l = b = ix == 1073291771 ? 4297306550709743731L : 4454258360616903473L;
            if (hx > 0) {
                a = MicroDouble.negate(a);
                b = MicroDouble.negate(b);
            }
            long z = MicroDouble.add(x, a);
            y[0] = MicroDouble.add(z, b);
            y[1] = MicroDouble.add(MicroDouble.sub(z, y[0]), b);
            return hx > 0 ? 1 : -1;
        }
        if (ix <= 1094263291) {
            long t = MicroDouble.abs(x);
            long fn = MicroDouble.rint(MicroDouble.mul(t, 4603909380684499075L));
            int n = MicroDouble.intValue(fn);
            long r = MicroDouble.sub(t, MicroDouble.mul(fn, 4609753056924401664L));
            long w = MicroDouble.mul(fn, 4454258360616903473L);
            if (n < 32 && ix != NPIO2_HW[n - 1]) {
                y[0] = MicroDouble.sub(r, w);
            } else {
                int j = ix >> 20;
                y[0] = MicroDouble.sub(r, w);
                int i = j - (MicroDouble.getHI(y[0]) >> 20 & 0x7FF);
                if (i > 16) {
                    t = r;
                    w = MicroDouble.mul(fn, 4454258360616747008L);
                    r = MicroDouble.sub(t, w);
                    w = MicroDouble.sub(MicroDouble.mul(fn, 4297306550709743731L), MicroDouble.sub(MicroDouble.sub(t, r), w));
                    y[0] = MicroDouble.sub(r, w);
                    i = j - (MicroDouble.getHI(y[0]) >> 20 & 0x7FF);
                    if (i > 49) {
                        t = r;
                        w = MicroDouble.mul(fn, 4297306550709518336L);
                        r = MicroDouble.sub(t, w);
                        w = MicroDouble.sub(MicroDouble.mul(fn, 4142048980368378305L), MicroDouble.sub(MicroDouble.sub(t, r), w));
                        y[0] = MicroDouble.sub(r, w);
                    }
                }
            }
            y[1] = MicroDouble.sub(MicroDouble.sub(r, y[0]), w);
            if (hx < 0) {
                y[0] = MicroDouble.negate(y[0]);
                y[1] = MicroDouble.negate(y[1]);
                return -n;
            }
            return n;
        }
        if (ix >= 0x7FF00000) {
            y[1] = 9221120237041090560L;
            y[0] = 9221120237041090560L;
            return 0;
        }
        long z = MicroDouble.getLO(x);
        int e0 = (ix >> 20) - 1046;
        z = MicroDouble.setHI(z, ix - (e0 << 20));
        long[] tx = new long[3];
        for (int i = 0; i < 2; ++i) {
            tx[i] = MicroDouble.intToDouble(MicroDouble.intValue(z));
            z = MicroDouble.scalbn(MicroDouble.sub(z, tx[i]), 24);
        }
        tx[2] = z;
        int nx = 3;
        while (MicroDouble.isZero(tx[nx - 1])) {
            --nx;
        }
        int n = MicroDouble.kernelRemPio2(tx, y, e0, nx);
        if (hx < 0) {
            y[0] = MicroDouble.negate(y[0]);
            y[1] = MicroDouble.negate(y[1]);
            return -n;
        }
        return n;
    }

    private static int kernelRemPio2(long[] x, long[] y, int e0, int nx) {
        int i;
        int ih;
        int n;
        long z;
        boolean recompute;
        int jk;
        int jp = jk = 4;
        int jx = nx - 1;
        int jv = (e0 - 3) / 24;
        if (jv < 0) {
            jv = 0;
        }
        int q0 = e0 - 24 * (jv + 1);
        int j = jv - jx;
        int m = jx + jk;
        long[] f = new long[20];
        int i2 = 0;
        while (i2 <= m) {
            f[i2] = j < 0 ? 0L : MicroDouble.intToDouble(TWO_OVER_PI[j]);
            ++i2;
            ++j;
        }
        long[] q = new long[20];
        for (int i3 = 0; i3 <= jk; ++i3) {
            long fw = 0L;
            for (j = 0; j <= jx; ++j) {
                fw = MicroDouble.add(fw, MicroDouble.mul(x[j], f[jx + i3 - j]));
            }
            q[i3] = fw;
        }
        int jz = jk;
        int[] iq = new int[20];
        do {
            recompute = false;
            int i4 = 0;
            z = q[jz];
            for (j = jz; j > 0; --j) {
                long fw = MicroDouble.intToDouble(MicroDouble.intValue(MicroDouble.scalbn(z, -24)));
                iq[i4] = MicroDouble.intValue(MicroDouble.sub(z, MicroDouble.scalbn(fw, 24)));
                z = MicroDouble.add(q[j - 1], fw);
                ++i4;
            }
            z = MicroDouble.scalbn(z, q0);
            z = MicroDouble.sub(z, MicroDouble.scalbn(MicroDouble.floor(MicroDouble.scalbn(z, -3)), 3));
            z = MicroDouble.sub(z, MicroDouble.mul(0x4020000000000000L, MicroDouble.floor(MicroDouble.mul(z, 4593671619917905920L))));
            n = MicroDouble.intValue(z);
            z = MicroDouble.sub(z, MicroDouble.intToDouble(n));
            ih = 0;
            if (q0 > 0) {
                i4 = iq[jz - 1] >> 24 - q0;
                n += i4;
                int n2 = jz - 1;
                iq[n2] = iq[n2] - (i4 << 24 - q0);
                ih = iq[jz - 1] >> 23 - q0;
            } else if (q0 == 0) {
                ih = iq[jz - 1] >> 23;
            } else if (MicroDouble.ge(z, 4602678819172646912L)) {
                ih = 2;
            }
            if (ih > 0) {
                ++n;
                boolean carry = false;
                for (i4 = 0; i4 < jz; ++i4) {
                    j = iq[i4];
                    if (!carry) {
                        if (j == 0) continue;
                        carry = true;
                        iq[i4] = 0x1000000 - j;
                        continue;
                    }
                    iq[i4] = 0xFFFFFF - j;
                }
                if (q0 > 0) {
                    switch (q0) {
                        case 1: {
                            int n3 = jz - 1;
                            iq[n3] = iq[n3] & 0x7FFFFF;
                            break;
                        }
                        case 2: {
                            int n4 = jz - 1;
                            iq[n4] = iq[n4] & 0x3FFFFF;
                        }
                    }
                }
                if (ih == 2) {
                    z = MicroDouble.sub(0x3FF0000000000000L, z);
                    if (carry) {
                        z = MicroDouble.sub(z, MicroDouble.scalbn(0x3FF0000000000000L, q0));
                    }
                }
            }
            if (!MicroDouble.isZero(z)) continue;
            j = 0;
            for (i4 = jz - 1; i4 >= jk; --i4) {
                j |= iq[i4];
            }
            if (j != 0) continue;
            int k = 1;
            while (iq[jk - k] == 0) {
                ++k;
            }
            for (i4 = jz + 1; i4 <= jz + k; ++i4) {
                f[jx + i4] = MicroDouble.intToDouble(TWO_OVER_PI[jv + i4]);
                long fw = 0L;
                for (j = 0; j <= jx; ++j) {
                    fw = MicroDouble.add(fw, MicroDouble.mul(x[j], f[jx + i4 - j]));
                }
                q[i4] = fw;
            }
            jz += k;
            recompute = true;
        } while (recompute);
        if (MicroDouble.isZero(z)) {
            --jz;
            q0 -= 24;
            while (iq[jz] == 0) {
                --jz;
                q0 -= 24;
            }
        } else if (MicroDouble.ge(z = MicroDouble.scalbn(z, -q0), 4715268809856909312L)) {
            long fw = MicroDouble.intToDouble(MicroDouble.intValue(MicroDouble.scalbn(z, -24)));
            iq[jz] = MicroDouble.intValue(MicroDouble.sub(z, MicroDouble.scalbn(fw, 24)));
            q0 += 24;
            iq[++jz] = MicroDouble.intValue(fw);
        } else {
            iq[jz] = MicroDouble.intValue(z);
        }
        long fw = MicroDouble.scalbn(0x3FF0000000000000L, q0);
        for (int i5 = jz; i5 >= 0; --i5) {
            q[i5] = MicroDouble.mul(fw, MicroDouble.intToDouble(iq[i5]));
            fw = MicroDouble.scalbn(fw, -24);
        }
        long[] fq = new long[20];
        for (i = jz; i >= 0; --i) {
            fw = 0L;
            for (int k = 0; k <= jp && k <= jz - i; ++k) {
                fw = MicroDouble.add(fw, MicroDouble.mul(PIO2[k], q[i + k]));
            }
            fq[jz - i] = fw;
        }
        fw = 0L;
        for (i = jz; i >= 0; --i) {
            fw = MicroDouble.add(fw, fq[i]);
        }
        y[0] = ih == 0 ? fw : MicroDouble.negate(fw);
        fw = MicroDouble.sub(fq[0], fw);
        for (i = 1; i <= jz; ++i) {
            fw = MicroDouble.add(fw, fq[i]);
        }
        y[1] = ih == 0 ? fw : MicroDouble.negate(fw);
        return n & 7;
    }

    private static long pOverQ(long t) {
        return MicroDouble.div(MicroDouble.mul(t, MicroDouble.add(4595172819793696085L, MicroDouble.mul(t, MicroDouble.add(-4623835544539140227L, MicroDouble.mul(t, MicroDouble.add(4596417465768494165L, MicroDouble.mul(t, MicroDouble.add(-4637438604930937029L, MicroDouble.mul(t, MicroDouble.add(4560439845004096136L, MicroDouble.mul(t, 4540259411154564873L))))))))))), MicroDouble.add(0x3FF0000000000000L, MicroDouble.mul(t, MicroDouble.add(-4610777653840302773L, MicroDouble.mul(t, MicroDouble.add(4611733184086379208L, MicroDouble.mul(t, MicroDouble.add(-4618997306433404583L, MicroDouble.mul(t, 4590215604441354882L)))))))));
    }

    public static final long asin(long d) {
        int hx = MicroDouble.getHI(d);
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x3FF00000) {
            if ((ix - 0x3FF00000 | MicroDouble.getLO(d)) == 0) {
                return MicroDouble.copySign(4609753056924675352L, d);
            }
            return 9221120237041090560L;
        }
        if (ix < 1071644672) {
            if (ix < 1044381696) {
                return d;
            }
            long t = MicroDouble.mul(d, d);
            long w = MicroDouble.pOverQ(t);
            return MicroDouble.add(d, MicroDouble.mul(d, w));
        }
        long w = MicroDouble.sub(0x3FF0000000000000L, MicroDouble.abs(d));
        long t = MicroDouble.scalbn(w, -1);
        long s = MicroDouble.sqrt(t);
        if (ix >= 0x3FEF3333) {
            w = MicroDouble.pOverQ(t);
            t = MicroDouble.sub(4609753056924675352L, MicroDouble.sub(MicroDouble.scalbn(MicroDouble.add(s, MicroDouble.mul(s, w)), 1), 4364452196894661639L));
        } else {
            w = MicroDouble.setLO(s, 0);
            long c = MicroDouble.div(MicroDouble.sub(t, MicroDouble.mul(w, w)), MicroDouble.add(s, w));
            long r = MicroDouble.pOverQ(t);
            long p = MicroDouble.sub(MicroDouble.mul(MicroDouble.scalbn(s, 1), r), MicroDouble.sub(4364452196894661639L, MicroDouble.scalbn(c, 1)));
            long q = MicroDouble.sub(4605249457297304856L, MicroDouble.scalbn(w, 1));
            t = MicroDouble.sub(4605249457297304856L, MicroDouble.sub(p, q));
        }
        return hx > 0 ? t : MicroDouble.negate(t);
    }

    public static long acos(long d) {
        int hx = MicroDouble.getHI(d);
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x3FF00000) {
            if ((ix - 0x3FF00000 | MicroDouble.getLO(d)) == 0) {
                if (hx > 0) {
                    return 0L;
                }
                return 4614256656552045848L;
            }
            return 9221120237041090560L;
        }
        if (ix < 1071644672) {
            if (ix <= 1012924416) {
                return 4609753056924675352L;
            }
            long z = MicroDouble.mul(d, d);
            long r = MicroDouble.pOverQ(z);
            return MicroDouble.sub(4609753056924675352L, MicroDouble.sub(d, MicroDouble.sub(4364452196894661639L, MicroDouble.mul(d, r))));
        }
        if (hx < 0) {
            long z = MicroDouble.scalbn(MicroDouble.add(0x3FF0000000000000L, d), -1);
            long s = MicroDouble.sqrt(z);
            long r = MicroDouble.pOverQ(z);
            long w = MicroDouble.sub(MicroDouble.mul(r, s), 4364452196894661639L);
            return MicroDouble.sub(4614256656552045848L, MicroDouble.scalbn(MicroDouble.add(s, w), 1));
        }
        long z = MicroDouble.scalbn(MicroDouble.sub(0x3FF0000000000000L, d), -1);
        long s = MicroDouble.sqrt(z);
        long df = MicroDouble.setLO(s, 0);
        long c = MicroDouble.div(MicroDouble.sub(z, MicroDouble.mul(df, df)), MicroDouble.add(s, df));
        long r = MicroDouble.pOverQ(z);
        long w = MicroDouble.add(MicroDouble.mul(r, s), c);
        return MicroDouble.scalbn(MicroDouble.add(df, w), 1);
    }

    public static long atan(long d) {
        int id;
        int hx = MicroDouble.getHI(d);
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x44100000) {
            if (ix > 0x7FF00000 || ix == 0x7FF00000 && MicroDouble.getLO(d) != 0) {
                return 9221120237041090560L;
            }
            return hx > 0 ? atanhi[3] : MicroDouble.negate(atanhi[3]);
        }
        if (ix < 1071382528) {
            if (ix < 1042284544) {
                return d;
            }
            id = -1;
        } else {
            d = MicroDouble.abs(d);
            if (ix < 0x3FF30000) {
                if (ix < 1072037888) {
                    id = 0;
                    d = MicroDouble.div(MicroDouble.sub(MicroDouble.scalbn(d, 1), 0x3FF0000000000000L), MicroDouble.add(0x4000000000000000L, d));
                } else {
                    id = 1;
                    d = MicroDouble.div(MicroDouble.sub(d, 0x3FF0000000000000L), MicroDouble.add(d, 0x3FF0000000000000L));
                }
            } else if (ix < 1073971200) {
                id = 2;
                d = MicroDouble.div(MicroDouble.sub(d, 4609434218613702656L), MicroDouble.add(0x3FF0000000000000L, MicroDouble.mul(4609434218613702656L, d)));
            } else {
                id = 3;
                d = MicroDouble.div(-4616189618054758400L, d);
            }
        }
        long z = MicroDouble.mul(d, d);
        long w = MicroDouble.mul(z, z);
        long s1 = MicroDouble.mul(z, MicroDouble.add(4599676419421066509L, MicroDouble.mul(w, MicroDouble.add(4594314991288484863L, MicroDouble.mul(w, MicroDouble.add(4591215095208222830L, MicroDouble.mul(w, MicroDouble.add(4589464229703073105L, MicroDouble.mul(w, MicroDouble.add(4587333258118041067L, MicroDouble.mul(w, 4580351289466214929L)))))))))));
        long s2 = MicroDouble.mul(w, MicroDouble.add(-4626998257160492092L, MicroDouble.mul(w, MicroDouble.add(-4630701217362536847L, MicroDouble.mul(w, MicroDouble.add(-4633165035261879699L, MicroDouble.mul(w, MicroDouble.add(-4634804155249132134L, MicroDouble.mul(w, -4637946461342241745L)))))))));
        if (id < 0) {
            return MicroDouble.sub(d, MicroDouble.mul(d, MicroDouble.add(s1, s2)));
        }
        z = MicroDouble.sub(atanhi[id], MicroDouble.sub(MicroDouble.sub(MicroDouble.mul(d, MicroDouble.add(s1, s2)), atanlo[id]), d));
        return hx < 0 ? MicroDouble.negate(z) : z;
    }

    public static long cosh(long d) {
        if (MicroDouble.isNaN(d)) {
            return 9221120237041090560L;
        }
        if (MicroDouble.isInfinite(d)) {
            return 0x7FF0000000000000L;
        }
        int ix = MicroDouble.getHI(d) & Integer.MAX_VALUE;
        if (ix < 1071001155) {
            long t = MicroDouble.expm1(MicroDouble.abs(d));
            long w = MicroDouble.add(0x3FF0000000000000L, t);
            if (ix < 1015021568) {
                return w;
            }
            return MicroDouble.add(0x3FF0000000000000L, MicroDouble.div(MicroDouble.mul(t, t), MicroDouble.add(w, w)));
        }
        if (ix < 1077280768) {
            long t = MicroDouble.exp(MicroDouble.abs(d));
            return MicroDouble.add(MicroDouble.scalbn(t, -1), MicroDouble.div(4602678819172646912L, t));
        }
        if (ix < 1082535490) {
            return MicroDouble.scalbn(MicroDouble.exp(MicroDouble.abs(d)), -1);
        }
        if (MicroDouble.abs(d) <= 4649460627574225021L) {
            long w = MicroDouble.exp(MicroDouble.scalbn(MicroDouble.abs(d), -1));
            long t = MicroDouble.scalbn(w, -1);
            return MicroDouble.mul(t, w);
        }
        return 0x7FF0000000000000L;
    }

    public static long sinh(long d) {
        if (MicroDouble.isNaN(d)) {
            return 9221120237041090560L;
        }
        if (MicroDouble.isInfinite(d)) {
            return 0x7FF0000000000000L;
        }
        int jx = MicroDouble.getHI(d);
        int ix = jx & Integer.MAX_VALUE;
        long h = 4602678819172646912L;
        if (jx < 0) {
            h = MicroDouble.negate(h);
        }
        if (ix < 1077280768) {
            if (ix < 0x3E300000) {
                return d;
            }
            long t = MicroDouble.expm1(MicroDouble.abs(d));
            if (ix < 0x3FF00000) {
                return MicroDouble.mul(h, MicroDouble.sub(MicroDouble.scalbn(t, 1), MicroDouble.mul(t, MicroDouble.div(t, MicroDouble.add(t, 0x3FF0000000000000L)))));
            }
            return MicroDouble.mul(h, MicroDouble.add(t, MicroDouble.div(t, MicroDouble.add(t, 0x3FF0000000000000L))));
        }
        if (ix < 1082535490) {
            return MicroDouble.mul(h, MicroDouble.exp(MicroDouble.abs(d)));
        }
        if (MicroDouble.abs(d) <= 4649460627574225021L) {
            long w = MicroDouble.exp(MicroDouble.scalbn(MicroDouble.abs(d), -1));
            long t = MicroDouble.mul(h, w);
            return MicroDouble.mul(t, w);
        }
        return MicroDouble.copySign(0x7FF0000000000000L, d);
    }

    public static long tanh(long d) {
        long z;
        if (MicroDouble.isNaN(d)) {
            return 9221120237041090560L;
        }
        if (MicroDouble.isInfinite(d)) {
            return MicroDouble.copySign(0x7FF0000000000000L, d);
        }
        int jx = MicroDouble.getHI(d);
        int ix = jx & Integer.MAX_VALUE;
        if (ix < 1077280768) {
            if (ix < 1015021568) {
                return d;
            }
            if (ix >= 0x3FF00000) {
                long t = MicroDouble.expm1(MicroDouble.scalbn(MicroDouble.abs(d), 1));
                z = MicroDouble.sub(0x3FF0000000000000L, MicroDouble.div(0x4000000000000000L, MicroDouble.add(t, 0x4000000000000000L)));
            } else {
                long t = MicroDouble.expm1(MicroDouble.negate(MicroDouble.mul(0x4000000000000000L, MicroDouble.abs(d))));
                z = MicroDouble.negate(MicroDouble.div(t, MicroDouble.add(t, 0x4000000000000000L)));
            }
        } else {
            z = 0x3FF0000000000000L;
        }
        return jx >= 0 ? z : MicroDouble.negate(z);
    }

    public static long acosh(long d) {
        if (MicroDouble.isNaN(d) || MicroDouble.lt(d, 0x3FF0000000000000L)) {
            return 9221120237041090560L;
        }
        if (d == 0x7FF0000000000000L) {
            return d;
        }
        if (d == 0x3FF0000000000000L) {
            return 0L;
        }
        int hx = MicroDouble.getHI(d);
        if (hx > 1102053376) {
            return MicroDouble.add(MicroDouble.log(d), 4604418534313441775L);
        }
        if (hx > 0x40000000) {
            long t = MicroDouble.mul(d, d);
            return MicroDouble.log(MicroDouble.sub(MicroDouble.scalbn(d, 1), MicroDouble.div(0x3FF0000000000000L, MicroDouble.add(d, MicroDouble.sqrt(MicroDouble.sub(t, 0x3FF0000000000000L))))));
        }
        long t = MicroDouble.sub(d, 0x3FF0000000000000L);
        return MicroDouble.log1p(MicroDouble.add(t, MicroDouble.sqrt(MicroDouble.add(MicroDouble.scalbn(t, 1), MicroDouble.mul(t, t)))));
    }

    public static long asinh(long d) {
        long w;
        int hx = MicroDouble.getHI(d);
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x7FF00000) {
            return d;
        }
        if (ix < 0x3E300000) {
            return d;
        }
        if (ix > 1102053376) {
            w = MicroDouble.add(MicroDouble.log(MicroDouble.abs(d)), 4604418534313441775L);
        } else if (ix > 0x40000000) {
            long t = MicroDouble.abs(d);
            w = MicroDouble.log(MicroDouble.add(MicroDouble.scalbn(t, 1), MicroDouble.div(0x3FF0000000000000L, MicroDouble.add(MicroDouble.sqrt(MicroDouble.add(MicroDouble.mul(d, d), 0x3FF0000000000000L)), t))));
        } else {
            long t = MicroDouble.mul(d, d);
            w = MicroDouble.log1p(MicroDouble.add(MicroDouble.abs(d), MicroDouble.div(t, MicroDouble.add(0x3FF0000000000000L, MicroDouble.sqrt(MicroDouble.add(0x3FF0000000000000L, t))))));
        }
        if (hx > 0) {
            return w;
        }
        return MicroDouble.negate(w);
    }

    public static long atanh(long d) {
        if (MicroDouble.isNaN(d) || MicroDouble.gt(d, 0x3FF0000000000000L) || MicroDouble.lt(d, -4616189618054758400L)) {
            return 9221120237041090560L;
        }
        boolean negate = MicroDouble.unpackSign(d);
        if ((d = MicroDouble.abs(d)) == 0x3FF0000000000000L) {
            d = 0x7FF0000000000000L;
        } else if (MicroDouble.lt(d, 4602678819172646912L)) {
            long t = MicroDouble.add(d, d);
            d = MicroDouble.scalbn(MicroDouble.log1p(MicroDouble.add(t, MicroDouble.div(MicroDouble.mul(t, d), MicroDouble.sub(0x3FF0000000000000L, d)))), -1);
        } else {
            d = MicroDouble.scalbn(MicroDouble.log1p(MicroDouble.div(MicroDouble.add(d, d), MicroDouble.sub(0x3FF0000000000000L, d))), -1);
        }
        if (negate) {
            d = MicroDouble.negate(d);
        }
        return d;
    }

    public static long percentChange(long d1, long d2) {
        return MicroDouble.mul(MicroDouble.div(MicroDouble.sub(d2, d1), d1), 4636737291354636288L);
    }

    public static long percentTotal(long d1, long d2) {
        return MicroDouble.mul(MicroDouble.div(d2, d1), 4636737291354636288L);
    }

    public static long factorial(long d) {
        if (MicroDouble.isZero(d)) {
            return 0x3FF0000000000000L;
        }
        if (!MicroDouble.isPositiveInteger(d)) {
            return 9221120237041090560L;
        }
        return MicroDouble.factorial(0x3FF0000000000000L, d, 0x3FF0000000000000L);
    }

    private static boolean isPositiveInteger(long d) {
        return !MicroDouble.unpackSign(d) && !MicroDouble.isNaN(d) && !MicroDouble.isInfinite(d) && !MicroDouble.isZero(d) && MicroDouble.rint(d) == d;
    }

    private static long factorial(long base, long d1, long d2) {
        while (d1 != d2 && base != 0x7FF0000000000000L) {
            base = MicroDouble.mul(base, d1);
            d1 = MicroDouble.add(d1, -4616189618054758400L);
        }
        return base;
    }

    public static long permutations(long d1, long d2) {
        if (!(MicroDouble.isPositiveInteger(d1) && MicroDouble.isPositiveInteger(d2) && MicroDouble.ge(d1, d2))) {
            return 9221120237041090560L;
        }
        return MicroDouble.factorial(0x3FF0000000000000L, d1, MicroDouble.sub(d1, d2));
    }

    public static long combinations(long d1, long d2) {
        if (!(MicroDouble.isPositiveInteger(d1) && MicroDouble.isPositiveInteger(d2) && MicroDouble.ge(d1, d2))) {
            return 9221120237041090560L;
        }
        long d3 = MicroDouble.sub(d1, d2);
        if (MicroDouble.gt(d3, d2)) {
            long tmp = d3;
            d3 = d2;
            d2 = tmp;
        }
        d3 = MicroDouble.isZero(d3) ? 0x3FF0000000000000L : MicroDouble.div(0x3FF0000000000000L, MicroDouble.factorial(0x3FF0000000000000L, d3, 0x3FF0000000000000L));
        return MicroDouble.factorial(d3, d1, d2);
    }

    public static long gamma(long d) {
        if (MicroDouble.isNaN(d) || MicroDouble.isZero(d) || MicroDouble.lt(d, 0L) && (d == -4503599627370496L || MicroDouble.rint(d) == d)) {
            return 9221120237041090560L;
        }
        return MicroDouble.lgamma(d, true);
    }

    public static long lgamma(long d) {
        return MicroDouble.lgamma(d, false);
    }

    private static long lgamma(long x, boolean exp) {
        long r;
        long nadj;
        long t;
        int hx = MicroDouble.getHI(x);
        int lx = MicroDouble.getLO(x);
        boolean negative = false;
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x7FF00000) {
            return MicroDouble.mul(x, x);
        }
        if ((ix | lx) == 0) {
            return 0x7FF0000000000000L;
        }
        if (ix < 999292928) {
            if (hx < 0) {
                negative = true;
                x = MicroDouble.negate(x);
            }
            x = MicroDouble.negate(MicroDouble.log(x));
            if (exp) {
                x = MicroDouble.exp(x);
                if (negative) {
                    x = MicroDouble.negate(x);
                }
            }
            return x;
        }
        if (hx < 0) {
            if (ix >= 0x43300000) {
                return 0x7FF0000000000000L;
            }
            t = MicroDouble.sinPi(x);
            if (MicroDouble.isZero(t)) {
                return 0x7FF0000000000000L;
            }
            nadj = MicroDouble.log(MicroDouble.div(4614256656552045848L, MicroDouble.abs(MicroDouble.mul(t, x))));
            if (MicroDouble.lt(t, 0L)) {
                negative = true;
            }
            x = MicroDouble.negate(x);
        } else {
            nadj = 0L;
        }
        if ((ix - 0x3FF00000 | lx) == 0 || (ix - 0x40000000 | lx) == 0) {
            r = 0L;
        } else if (ix < 0x40000000) {
            int i;
            long y;
            if (ix <= 1072483532) {
                r = MicroDouble.negate(MicroDouble.log(x));
                if (ix >= 1072130372) {
                    y = MicroDouble.sub(0x3FF0000000000000L, x);
                    i = 0;
                } else if (ix >= 1070442081) {
                    y = MicroDouble.sub(x, MicroDouble.sub(4609261425156079167L, 0x3FF0000000000000L));
                    i = 1;
                } else {
                    y = x;
                    i = 2;
                }
            } else {
                r = 0L;
                if (ix >= 1073460419) {
                    y = MicroDouble.sub(0x4000000000000000L, x);
                    i = 0;
                } else if (ix >= 1072936132) {
                    y = MicroDouble.sub(x, 4609261425156079167L);
                    i = 1;
                } else {
                    y = MicroDouble.sub(x, 0x3FF0000000000000L);
                    i = 2;
                }
            }
            switch (i) {
                case 0: {
                    long z = MicroDouble.mul(y, y);
                    long p1 = MicroDouble.add(4590228395698008264L, MicroDouble.mul(z, MicroDouble.add(4589517665429971623L, MicroDouble.mul(z, MicroDouble.add(4575164982564483048L, MicroDouble.mul(z, MicroDouble.add(4563143216008740701L, MicroDouble.mul(z, MicroDouble.add(4552280422768239949L, MicroDouble.mul(z, 4538063219164248658L))))))))));
                    long p2 = MicroDouble.mul(z, MicroDouble.add(4599480669564178349L, MicroDouble.mul(z, MicroDouble.add(4581589235564434555L, MicroDouble.mul(z, MicroDouble.add(4568811493649781355L, MicroDouble.mul(z, MicroDouble.add(4557843786729364480L, MicroDouble.mul(z, MicroDouble.add(4547598271341525767L, MicroDouble.mul(z, 4541745596584974391L)))))))))));
                    long p = MicroDouble.add(MicroDouble.mul(y, p1), p2);
                    r = MicroDouble.add(r, MicroDouble.sub(p, MicroDouble.scalbn(y, -1)));
                    break;
                }
                case 1: {
                    long z = MicroDouble.mul(y, y);
                    long w = MicroDouble.mul(z, y);
                    long p1 = MicroDouble.add(4602387636645935266L, MicroDouble.mul(w, MicroDouble.add(-4638485889055082733L, MicroDouble.mul(w, MicroDouble.add(4573683464413438788L, MicroDouble.mul(w, MicroDouble.add(-4659256875421984015L, MicroDouble.mul(w, 4554458007677615095L))))))));
                    long p2 = MicroDouble.add(-4628886608449977079L, MicroDouble.mul(w, MicroDouble.add(4580836915846773228L, MicroDouble.mul(w, MicroDouble.add(-4652729689257208617L, MicroDouble.mul(w, MicroDouble.add(4561265769268226281L, MicroDouble.mul(w, -4668967117108573128L))))))));
                    long p3 = MicroDouble.add(4589321138371641755L, MicroDouble.mul(w, MicroDouble.add(-4646272669672412054L, MicroDouble.mul(w, MicroDouble.add(4567356815629994261L, MicroDouble.mul(w, MicroDouble.add(-4665265148704595732L, MicroDouble.mul(w, 4554825044790006772L))))))));
                    long p = MicroDouble.sub(MicroDouble.mul(z, p1), MicroDouble.sub(-4877178723284379873L, MicroDouble.mul(w, MicroDouble.add(p2, MicroDouble.mul(y, p3)))));
                    r = MicroDouble.add(r, MicroDouble.add(-4629953606387004862L, p));
                    break;
                }
                case 2: {
                    long p1 = MicroDouble.mul(y, MicroDouble.add(-4633143641156767544L, MicroDouble.mul(y, MicroDouble.add(4603875219004743167L, MicroDouble.mul(y, MicroDouble.add(4609231207607680367L, MicroDouble.mul(y, MicroDouble.add(4606981716134495312L, MicroDouble.mul(y, MicroDouble.add(4597417307973683492L, MicroDouble.mul(y, 4578867296057666313L)))))))))));
                    long p2 = MicroDouble.add(0x3FF0000000000000L, MicroDouble.mul(y, MicroDouble.add(4612712789461262748L, MicroDouble.mul(y, MicroDouble.add(4611975351653570805L, MicroDouble.mul(y, MicroDouble.add(4605104324179153071L, MicroDouble.mul(y, MicroDouble.add(4592174453748890760L, MicroDouble.mul(y, 4569564532599476065L))))))))));
                    r = MicroDouble.add(r, MicroDouble.add(MicroDouble.negate(MicroDouble.scalbn(y, -1)), MicroDouble.div(p1, p2)));
                }
            }
        } else if (ix < 0x40200000) {
            int i = MicroDouble.intValue(x);
            t = 0L;
            long y = MicroDouble.sub(x, MicroDouble.intToDouble(i));
            long p = MicroDouble.mul(y, MicroDouble.add(-4633143641156767544L, MicroDouble.mul(y, MicroDouble.add(4596913578117826680L, MicroDouble.mul(y, MicroDouble.add(4599540328982355801L, MicroDouble.mul(y, MicroDouble.add(4594440851763360503L, MicroDouble.mul(y, MicroDouble.add(4583336332999498081L, MicroDouble.mul(y, MicroDouble.add(4566129637262422585L, MicroDouble.mul(y, 4539839448431978821L)))))))))))));
            long q = MicroDouble.add(0x3FF0000000000000L, MicroDouble.mul(y, MicroDouble.add(4608947853879192436L, MicroDouble.mul(y, MicroDouble.add(4604677836871294172L, MicroDouble.mul(y, MicroDouble.add(4595362590636105511L, MicroDouble.mul(y, MicroDouble.add(4581031541704938613L, MicroDouble.mul(y, MicroDouble.add(4560314476338981211L, MicroDouble.mul(y, 4530263847980990784L))))))))))));
            r = MicroDouble.add(MicroDouble.scalbn(y, -1), MicroDouble.div(p, q));
            long z = 0x3FF0000000000000L;
            switch (i) {
                case 7: {
                    z = MicroDouble.mul(z, MicroDouble.add(y, 4618441417868443648L));
                }
                case 6: {
                    z = MicroDouble.mul(z, MicroDouble.add(y, 0x4014000000000000L));
                }
                case 5: {
                    z = MicroDouble.mul(z, MicroDouble.add(y, 0x4010000000000000L));
                }
                case 4: {
                    z = MicroDouble.mul(z, MicroDouble.add(y, 0x4008000000000000L));
                }
                case 3: {
                    z = MicroDouble.mul(z, MicroDouble.add(y, 0x4000000000000000L));
                    r = MicroDouble.add(r, MicroDouble.log(z));
                }
            }
        } else if (ix < 1133510656) {
            t = MicroDouble.log(x);
            long z = MicroDouble.div(0x3FF0000000000000L, x);
            long y = MicroDouble.mul(z, z);
            long w = MicroDouble.add(4601218545606032745L, MicroDouble.mul(z, MicroDouble.add(4590669220166325563L, MicroDouble.mul(y, MicroDouble.add(-4654820494859555236L, MicroDouble.mul(y, MicroDouble.add(4560459357641193654L, MicroDouble.mul(y, MicroDouble.add(-4664743177309132991L, MicroDouble.mul(y, MicroDouble.add(4560853097493747153L, MicroDouble.mul(y, -4658207879917059100L))))))))))));
            r = MicroDouble.add(MicroDouble.mul(MicroDouble.sub(x, 4602678819172646912L), MicroDouble.sub(t, 0x3FF0000000000000L)), w);
        } else {
            r = MicroDouble.mul(x, MicroDouble.sub(MicroDouble.log(x), 0x3FF0000000000000L));
        }
        if (hx < 0) {
            r = MicroDouble.sub(nadj, r);
        }
        if (exp) {
            r = MicroDouble.exp(r);
            if (negative) {
                r = MicroDouble.negate(r);
            }
        }
        return r;
    }

    private static long sinPi(long x) {
        int n;
        int ix = Integer.MAX_VALUE & MicroDouble.getHI(x);
        if (ix < 1070596096) {
            return MicroDouble.kernelSin(MicroDouble.mul(4614256656552045848L, x), 0L, 0);
        }
        long y = MicroDouble.negate(x);
        long z = MicroDouble.floor(y);
        if (MicroDouble.ne(z, y)) {
            y = MicroDouble.scalbn(y, -1);
            y = MicroDouble.scalbn(MicroDouble.sub(y, MicroDouble.floor(y)), 1);
            n = MicroDouble.intValue(MicroDouble.scalbn(y, 2));
        } else if (ix >= 0x43400000) {
            y = 0L;
            n = 0;
        } else {
            if (ix < 0x43300000) {
                z = MicroDouble.add(y, 0x4330000000000000L);
            }
            n = MicroDouble.getLO(z) & 1;
            y = MicroDouble.intToDouble(n);
            n <<= 2;
        }
        switch (n) {
            case 0: {
                y = MicroDouble.kernelSin(MicroDouble.mul(4614256656552045848L, y), 0L, 0);
                break;
            }
            case 1: 
            case 2: {
                y = MicroDouble.kernelCos(MicroDouble.mul(4614256656552045848L, MicroDouble.sub(4602678819172646912L, y)), 0L);
                break;
            }
            case 3: 
            case 4: {
                y = MicroDouble.kernelSin(MicroDouble.mul(4614256656552045848L, MicroDouble.sub(0x3FF0000000000000L, y)), 0L, 0);
                break;
            }
            case 5: 
            case 6: {
                y = MicroDouble.negate(MicroDouble.kernelCos(MicroDouble.mul(4614256656552045848L, MicroDouble.sub(y, 4609434218613702656L)), 0L));
                break;
            }
            default: {
                y = MicroDouble.kernelSin(MicroDouble.mul(4614256656552045848L, MicroDouble.sub(y, 0x4000000000000000L)), 0L, 0);
            }
        }
        return MicroDouble.negate(y);
    }

    public MicroDouble(long d) {
        if (MicroDouble.isNaN(d)) {
            d = 9221120237041090560L;
        }
        this.value = d;
    }

    public MicroDouble(String s) {
        this(MicroDouble.parseDouble(s));
    }

    public long doubleValue() {
        return this.value;
    }

    public String toString() {
        return MicroDouble.toString(this.value);
    }

    public int hashCode() {
        return (int)this.value ^ (int)(this.value >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof MicroDouble && ((MicroDouble)obj).value == this.value;
    }

    static {
        pow10m = new long[]{-815021110370542983L, -1228264617323800998L, -1631822729582842028L, -2025922448585811784L, -2410785455424649436L, -2786628235540701831L, -3153662200497784248L, -3512093806901185046L, -3862124672529506137L, -4203951689744663453L, -4537767136243840519L, -4863758783215693123L, -5182110000961642932L, -5492999862041672041L, -5796603242002637969L, -6093090917745768758L, -6382629663588669918L, -6665382345075878083L, -6941508010590729807L, -7211161980820077193L, -7474495936122174249L, -7731658001846878407L, -7982792831656159810L, -8228041688891786180L, -8467542526035952558L, -8701430062309552536L, -8929835859451740014L, -9152888395723407474L, -294682202642863838L, -720121152745989333L, -1135588877456072824L, -1541319077368263733L, -1937539975720012667L, -2324474446766642487L, -2702340141148116919L, -3071349608317525545L, -3431710416100151156L, -3783625267450371479L, -4127292114472071014L, -4462904269766699465L, -4790650515171610063L, -5110715207949843068L, -5423278384491086237L, -5728515861582144019L, -6026599335303880135L, -6317696477610263060L, -6601971030643840136L, -6879582898840692748L, -7150688238876681628L, -7415439547505577019L, -7673985747338482673L, -7926472270612804602L, -8173041140997884610L, -8413831053483314305L, -8648977452394866742L, -8878612607581929669L, -9102865688819295808L, -196981603220770741L, -624710411122851543L, -1042414325089727326L, -1450328303573004458L, -1848681798185579782L, -2237698882768172872L, -2617598379430861436L, -2988593981640518237L, -3350894374423386207L, -3704703351750405709L, -4050219931171323191L, -4387638465762062920L, -4717148753448332186L, -5038936143766954516L, -5353181642124984136L, -5660062011615247436L, -5959749872445582690L, -6252413799037706962L, -6538218414850328321L, -6817324484979841367L, -7089889006590693951L, -7356065297226292178L, -7616003081050118571L, -7869848573065574033L, -8117744561361917257L, -8359830487432564938L, -8596242524610931813L, -8827113654667930715L, -9052573742614218704L, -98755145788979523L, -528786136287117932L, -948738275445456221L, -1358847786342270957L, -1759345355577441597L, -2150456263033662926L, -2532400508596379067L, -2905392935903719049L, -3269643353196043249L, -3625356651333078602L, -3972732919045027188L, -4311967555482476979L, -4643251380128424041L, -4966770740134231719L, -5282707615139903279L, -5591239719637629412L, -5892540602936190088L, -6186779746782440749L, -6474122660694794910L, -6754730975062328270L, -7028762532061872568L, -7296371474444240045L, -7557708332239520785L, -7812920107430224633L, -8062150356639896359L, -8305539271883716404L, -8543223759426509417L, -8775337516792518218L, -9002011107970261189L, Long.MIN_VALUE, -432345564227567616L, -854558029293551616L, -1266874889709551616L, -1669528073709551616L, -2062744073709551616L, -2446744073709551616L, -2821744073709551616L, -3187955011209551616L, -3545582879861895366L, -3894828845342699809L, -4235889358507547899L, -4568956265895094861L, -4894216917640746191L, -5211854272861108818L, -5522047002568494196L, -5824969590173362729L, -6120792429631242156L, -6409681921289327534L, -6691800565486676536L, -6967307053960650171L, -7236356359111015049L, -7499099821171918249L, -7755685233340769031L, -8006256924911912373L, -8250955842461857043L, -8489919629131724885L, -8723282702051517699L, -8951176327949752869L, -9173728696990998152L, -335385916056126881L, -759870872876129023L, -1174406963520662365L, -1579227364540714457L, -1974559787411859078L, -2360626606621961247L, -2737644984756826646L, -3105826994654156138L, -3465379738694516969L, -3816505465296431844L, -4159401682681114338L, -4494261269970843337L, -4821272585683469312L, -5140619573684080616L, -5452481866653427593L, -5757034887131305500L, -6054449946191733143L, -6344894339805432013L, -6628531442943809817L, -6905520801477381890L, -7176018221920323368L, -7440175859071633405L, -7698142301602209613L, -7950062655635975441L, -8196078626372074883L, -8436328597794046994L, -8670947710510816633L, -8900067937773286985L, -9123818159709293187L, -237904397927796872L, -664674077828931748L, -1081441343357383777L, -1488440626100012710L, -1885900863153361278L, -2274045625900771989L, -2653093245771290262L, -3023256937051093262L, -3384744916816525880L, -3737760522056206171L, -4082502324048081455L, -4419164240055772162L, -4747935642407032618L, -5069001465015685407L, -5382542307406947896L, -5688734536304665171L, -5987750384837592197L, -6279758049420528746L, -6564921784364802719L, -6843401994271320271L, -7115355324258153818L, -7380934748073420954L, -7640289654143017767L, -7893565929601608404L, -8140906042354138323L, -8382449121214030822L, -8618331034163144591L, -8848684464777513505L, -9073638986861858148L, -139898200960150312L, -568964901102714405L, -987975350460687152L, -1397165242411832413L, -1796764746270372707L, -2186998636757228463L, -2568086420435798537L, -2940242459184402124L, -3303676090774835316L, -3658591746624867729L, -4005189066790915007L, -4343663012265570553L, -4674203974643163859L, -4996997883215032322L, -5312226309554747618L, -5620066569652125837L};
        pow10x = new short[]{-1146, -1136, -1126, -1116, -1106, -1096, -1086, -1076, -1066, -1056, -1046, -1036, -1026, -1016, -1006, -996, -986, -976, -966, -956, -946, -936, -926, -916, -906, -896, -886, -876, -867, -857, -847, -837, -827, -817, -807, -797, -787, -777, -767, -757, -747, -737, -727, -717, -707, -697, -687, -677, -667, -657, -647, -637, -627, -617, -607, -597, -587, -578, -568, -558, -548, -538, -528, -518, -508, -498, -488, -478, -468, -458, -448, -438, -428, -418, -408, -398, -388, -378, -368, -358, -348, -338, -328, -318, -308, -298, -289, -279, -269, -259, -249, -239, -229, -219, -209, -199, -189, -179, -169, -159, -149, -139, -129, -119, -109, -99, -89, -79, -69, -59, -49, -39, -29, -19, -9, 1, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 210, 220, 230, 240, 250, 260, 270, 280, 290, 299, 309, 319, 329, 339, 349, 359, 369, 379, 389, 399, 409, 419, 429, 439, 449, 459, 469, 479, 489, 499, 509, 519, 529, 539, 549, 559, 569, 579, 588, 598, 608, 618, 628, 638, 648, 658, 668, 678, 688, 698, 708, 718, 728, 738, 748, 758, 768, 778, 788, 798, 808, 818, 828, 838, 848, 858, 868, 877, 887, 897, 907, 917, 927, 937, 947, 957, 967, 977, 987, 997, 1007, 1017, 1027};
        pow2m = new long[]{4556951262222748433L, -9114107888677362826L, 1911323890694592264L, 3914391328142524957L, 8016673440035891112L, -2028596868516046619L, 3362436547623629823L, 6886270049533193878L, -4343663012265570553L, 2888311001383727322L, 5915260930833873555L, -6332289687361778576L, 2481040258324023919L, 5081170449047600985L, -8040506994060064798L, 2131197353912214900L, 4364692180812216116L, 8938889586303418605L, -139898200960150312L, 3749242034739077387L, 7678447687145630489L, -2721283210435300375L, 3220574384798566654L, 6595736340067464508L, -4938676049251384304L, 2766452331409032665L, 5665694374725698899L, -6843401994271320271L, 2376364457868949779L, 4866794409715609148L, -8479549122611984080L, 2041281525984781831L, 4180544565216833190L, 8561755269564074374L, -912269281642327298L, 3591060437415367540L, 7354491775826672723L, -3384744916816525880L, 3084697427331691671L, 6317460331175304542L, -5508585315462527915L, 2649734913688990454L, 5426657103235052450L, -7332950326284164199L, 2276104959472719343L, 4661462957000129215L, -8900067937773286985L, 1955159272639746997L, 4004166190366201849L, 8200532357869981386L, -1652053804791829737L, 3439552567074349441L, 7044203657368267655L, -4020214983419339459L, 2954553157691435450L, 6050924866952059801L, -6054449946191733143L, 2537941837315649223L, 5197704882822449609L, -7801844473689174816L, 2180075438084173169L, 4464794497196386649L, 9143899130258199858L, 1872670541876879331L, 3835229269763848870L, 7854549544476362485L, -2360626606621961247L, 3294436857259538508L, 6747006683667534864L, -4628874385558440215L, 2829899712133347615L, 5795634610449095915L, -6577284391509803182L, 2430865342914508479L, 4978412222288913366L, -8250955842461857043L, 2088097429759527849L, 4276423536147513034L, 8758115402030106693L, -510123730351893108L, 3673419846319648462L, 7523163845262640051L, -3039304518611664792L, 3155443620884047222L, 6462348535570528710L, -5211854272861108818L, 2710505431213761085L, 5551115123125782702L, -7078060301547948642L, 2328306436538696289L, 4768371582031250000L, -8681119073709551616L, 2000000000000000000L, 4096000000000000000L, 8388608000000000000L, -1266874889709551616L, 3518437208883200000L, 0x6400000000000000L, -3689348814741910323L, 3022314549036572937L, 6189700196426901374L, -5770238071427257601L, 2596148429267413814L, 5316911983139663492L, -7557708332239520785L, 2230074519853062314L, 4567192616659071619L, -9093133594791772939L, 1915619426082361073L, 3923188584616675477L, 8034690221294951378L, -1991698500497491194L, 3369993333393829974L, 6901746346790563787L, -4311967555482476979L, 2894802230932904886L, 5928554968950589206L, -6305063497298744923L, 2486616182048933211L, 5092589940836215216L, -8017119874876982854L, 2135987035920910082L, 4374501449566023849L, 8958978968711216842L, -98755145788979523L, 3757668132438133165L, 7695704335233296721L, -2685941595151759931L, 3227812347608635737L, 6610559687902485990L, -4908317832885260309L, 2772669694120814860L, 5678427533559428832L, -6817324484979841367L, 2381705131771844659L, 4877732109868737862L, -8457148712698376476L, 2045869129935088669L, 4189939978107061594L, 8580997075163262144L, -872862063775190746L, 3599131035634557106L, 7371020360979572954L, -3350894374423386207L, 3091630018413806676L, 6331658277711476072L, -5479507920956448621L, 2655689964083835493L, 5438853046443695091L, -7307973034592864070L, 2281220308811097609L, 4671939192445127904L, -8878612607581929669L, 1959553324262936975L, 4013165208090494924L, 8218962346169333605L, -1614309188754756393L, 3447282664438742062L, 7060034896770543742L, -3987792605123478032L, 2961193260766427870L, 6064523798049644278L, -6026599335303880135L, 2543645642425481519L, 5209386275687386152L, -7777920981101784777L, 2184974969366070649L, 4474828737261712688L, 9164449253911987585L, 1876879207201175057L, 3843848616348006518L, 7872201966280717348L, -2324474446766642487L, 3301840819597907790L, 6762169998536515153L, -4597819916706768582L, 2836259667354169965L, 5808659798741340089L, -6550608805887287114L, 2436328502849999770L, 4989600773836799529L, -8228041688891786180L, 2092790248410678361L, 4286034428745069284L, 8777798510069901893L, -469812725086392539L, 3681675540198022979L};
        pow2x = new short[]{-323, -320, -316, -313, -310, -307, -303, -300, -297, -293, -290, -287, -283, -280, -277, -273, -270, -267, -264, -260, -257, -254, -250, -247, -244, -240, -237, -234, -230, -227, -224, -220, -217, -214, -211, -207, -204, -201, -197, -194, -191, -187, -184, -181, -177, -174, -171, -167, -164, -161, -158, -154, -151, -148, -144, -141, -138, -134, -131, -128, -124, -121, -118, -114, -111, -108, -105, -101, -98, -95, -91, -88, -85, -81, -78, -75, -71, -68, -65, -62, -58, -55, -52, -48, -45, -42, -38, -35, -32, -28, -25, -22, -18, -15, -12, -9, -5, -2, 1, 5, 8, 11, 15, 18, 21, 25, 28, 31, 35, 38, 41, 44, 48, 51, 54, 58, 61, 64, 68, 71, 74, 78, 81, 84, 87, 91, 94, 97, 101, 104, 107, 111, 114, 117, 121, 124, 127, 131, 134, 137, 140, 144, 147, 150, 154, 157, 160, 164, 167, 170, 174, 177, 180, 184, 187, 190, 193, 197, 200, 203, 207, 210, 213, 217, 220, 223, 227, 230, 233, 237, 240, 243, 246, 250, 253, 256, 260, 263, 266, 270, 273, 276, 280, 283, 286, 289, 293};
        BP = new long[]{0x3FF0000000000000L, 4609434218613702656L};
        DP_HI = new long[]{0L, 4603444093224222720L};
        DP_LO = new long[]{0L, 4489242115478376454L};
        S1 = -4628199217061079735L;
        S2 = 4575957461383575718L;
        S3 = -4671919876304969259L;
        S4 = 4523617212983017085L;
        S5 = -4730215680275931925L;
        S6 = 4460209850635244924L;
        PIO2 = new long[]{4609753056584663040L, 4500296887714185216L, 4393339057296375808L, 4285399695318056960L, 4174867106174599168L, 4069606033725587456L, 3955147982449410048L, 3848874662444400640L};
        TWO_OVER_PI = new int[]{10680707, 0x6E4E44, 1387004, 2578385, 16069853, 12639074, 9804092, 4427841, 16666979, 11263675, 12935607, 2387514, 0x424DD2, 14681673, 3074569, 13734428, 16653803, 1880361, 10960616, 8533493, 3062596, 8710556, 7349940, 6258241, 3772886, 3769171, 3798172, 8675211, 12450088, 3874808, 9961438, 366607, 15675153, 9132554, 7151469, 3571407, 2607881, 12013382, 4155038, 6285869, 7677882, 13102053, 15825725, 473591, 9065106, 15363067, 6271263, 9264392, 5636912, 4652155, 7056368, 13614112, 10155062, 1944035, 9527646, 15080200, 6658437, 6231200, 6832269, 16767104, 5075751, 3212806, 1398474, 7579849, 6349435, 12618859};
        NPIO2_HW = new int[]{1073291771, 1074340347, 1074977148, 1075388923, 1075800698, 1076025724, 1076231611, 1076437499, 1076643386, 1076849274, 1076971356, 1077074300, 1077177244, 1077280187, 1077383131, 1077486075, 1077589019, 1077691962, 1077794906, 1077897850, 1077968460, 1078019932, 1078071404, 1078122876, 1078174348, 1078225820, 1078277292, 1078328763, 1078380235, 1078431707, 1078483179, 1078534651};
        atanhi = new long[]{4602023952714414927L, 4605249457297304856L, 4607027438436873883L, 4609753056924675352L};
        atanlo = new long[]{4357843414468748770L, 4359948597267291143L, 4354989122426817469L, 4364452196894661639L};
    }
}

